// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Mode of the service mesh. </summary>
    public readonly partial struct ServiceMeshMode : IEquatable<ServiceMeshMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceMeshMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceMeshMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IstioValue = "Istio";
        private const string DisabledValue = "Disabled";

        /// <summary> Istio deployed as an AKS addon. </summary>
        public static ServiceMeshMode Istio { get; } = new ServiceMeshMode(IstioValue);
        /// <summary> Mesh is disabled. </summary>
        public static ServiceMeshMode Disabled { get; } = new ServiceMeshMode(DisabledValue);
        /// <summary> Determines if two <see cref="ServiceMeshMode"/> values are the same. </summary>
        public static bool operator ==(ServiceMeshMode left, ServiceMeshMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceMeshMode"/> values are not the same. </summary>
        public static bool operator !=(ServiceMeshMode left, ServiceMeshMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceMeshMode"/>. </summary>
        public static implicit operator ServiceMeshMode(string value) => new ServiceMeshMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceMeshMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceMeshMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
