// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The eviction policy specifies what to do with the VM when it is evicted. The default is Delete. For more information about eviction see [spot VMs](https://docs.microsoft.com/azure/virtual-machines/spot-vms). </summary>
    public readonly partial struct ScaleSetEvictionPolicy : IEquatable<ScaleSetEvictionPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScaleSetEvictionPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScaleSetEvictionPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DeallocateValue = "Deallocate";

        /// <summary> Nodes in the underlying Scale Set of the node pool are deleted when they're evicted. </summary>
        public static ScaleSetEvictionPolicy Delete { get; } = new ScaleSetEvictionPolicy(DeleteValue);
        /// <summary> Nodes in the underlying Scale Set of the node pool are set to the stopped-deallocated state upon eviction. Nodes in the stopped-deallocated state count against your compute quota and can cause issues with cluster scaling or upgrading. </summary>
        public static ScaleSetEvictionPolicy Deallocate { get; } = new ScaleSetEvictionPolicy(DeallocateValue);
        /// <summary> Determines if two <see cref="ScaleSetEvictionPolicy"/> values are the same. </summary>
        public static bool operator ==(ScaleSetEvictionPolicy left, ScaleSetEvictionPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScaleSetEvictionPolicy"/> values are not the same. </summary>
        public static bool operator !=(ScaleSetEvictionPolicy left, ScaleSetEvictionPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScaleSetEvictionPolicy"/>. </summary>
        public static implicit operator ScaleSetEvictionPolicy(string value) => new ScaleSetEvictionPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScaleSetEvictionPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScaleSetEvictionPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
