// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Describes how VMs are added to or removed from Agent Pools. See [billing states](https://docs.microsoft.com/azure/virtual-machines/states-billing). </summary>
    public readonly partial struct ScaleDownMode : IEquatable<ScaleDownMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScaleDownMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScaleDownMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DeallocateValue = "Deallocate";

        /// <summary> Create new instances during scale up and remove instances during scale down. </summary>
        public static ScaleDownMode Delete { get; } = new ScaleDownMode(DeleteValue);
        /// <summary> Attempt to start deallocated instances (if they exist) during scale up and deallocate instances during scale down. </summary>
        public static ScaleDownMode Deallocate { get; } = new ScaleDownMode(DeallocateValue);
        /// <summary> Determines if two <see cref="ScaleDownMode"/> values are the same. </summary>
        public static bool operator ==(ScaleDownMode left, ScaleDownMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScaleDownMode"/> values are not the same. </summary>
        public static bool operator !=(ScaleDownMode left, ScaleDownMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScaleDownMode"/>. </summary>
        public static implicit operator ScaleDownMode(string value) => new ScaleDownMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScaleDownMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScaleDownMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
