// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Network dataplane used in the Kubernetes cluster. </summary>
    public readonly partial struct NetworkDataplane : IEquatable<NetworkDataplane>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkDataplane"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkDataplane(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "azure";
        private const string CiliumValue = "cilium";

        /// <summary> Use Azure network dataplane. </summary>
        public static NetworkDataplane Azure { get; } = new NetworkDataplane(AzureValue);
        /// <summary> Use Cilium network dataplane. See [Azure CNI Powered by Cilium](https://learn.microsoft.com/azure/aks/azure-cni-powered-by-cilium) for more information. </summary>
        public static NetworkDataplane Cilium { get; } = new NetworkDataplane(CiliumValue);
        /// <summary> Determines if two <see cref="NetworkDataplane"/> values are the same. </summary>
        public static bool operator ==(NetworkDataplane left, NetworkDataplane right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkDataplane"/> values are not the same. </summary>
        public static bool operator !=(NetworkDataplane left, NetworkDataplane right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkDataplane"/>. </summary>
        public static implicit operator NetworkDataplane(string value) => new NetworkDataplane(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkDataplane other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkDataplane other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
