// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Mesh upgrade profile properties for a major.minor release. </summary>
    public partial class MeshUpgradeProfileProperties : MeshRevision
    {
        /// <summary> Initializes a new instance of <see cref="MeshUpgradeProfileProperties"/>. </summary>
        public MeshUpgradeProfileProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MeshUpgradeProfileProperties"/>. </summary>
        /// <param name="revision"> The revision of the mesh release. </param>
        /// <param name="upgrades"> List of revisions available for upgrade of a specific mesh revision. </param>
        /// <param name="compatibleWith"> List of items this revision of service mesh is compatible with, and their associated versions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MeshUpgradeProfileProperties(string revision, IList<string> upgrades, IList<CompatibleVersions> compatibleWith, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(revision, upgrades, compatibleWith, serializedAdditionalRawData)
        {
        }
    }
}
