// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Holds information on upgrades and compatibility for given major.minor mesh release. </summary>
    public partial class MeshRevision
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MeshRevision"/>. </summary>
        public MeshRevision()
        {
            Upgrades = new ChangeTrackingList<string>();
            CompatibleWith = new ChangeTrackingList<CompatibleVersions>();
        }

        /// <summary> Initializes a new instance of <see cref="MeshRevision"/>. </summary>
        /// <param name="revision"> The revision of the mesh release. </param>
        /// <param name="upgrades"> List of revisions available for upgrade of a specific mesh revision. </param>
        /// <param name="compatibleWith"> List of items this revision of service mesh is compatible with, and their associated versions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MeshRevision(string revision, IList<string> upgrades, IList<CompatibleVersions> compatibleWith, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Revision = revision;
            Upgrades = upgrades;
            CompatibleWith = compatibleWith;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The revision of the mesh release. </summary>
        [WirePath("revision")]
        public string Revision { get; set; }
        /// <summary> List of revisions available for upgrade of a specific mesh revision. </summary>
        [WirePath("upgrades")]
        public IList<string> Upgrades { get; }
        /// <summary> List of items this revision of service mesh is compatible with, and their associated versions. </summary>
        [WirePath("compatibleWith")]
        public IList<CompatibleVersions> CompatibleWith { get; }
    }
}
