// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Storage profile for the container service cluster. </summary>
    public partial class ManagedClusterStorageProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterStorageProfile"/>. </summary>
        public ManagedClusterStorageProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagedClusterStorageProfile"/>. </summary>
        /// <param name="diskCsiDriver"> AzureDisk CSI Driver settings for the storage profile. </param>
        /// <param name="fileCsiDriver"> AzureFile CSI Driver settings for the storage profile. </param>
        /// <param name="snapshotController"> Snapshot Controller settings for the storage profile. </param>
        /// <param name="blobCsiDriver"> AzureBlob CSI Driver settings for the storage profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedClusterStorageProfile(ManagedClusterStorageProfileDiskCsiDriver diskCsiDriver, ManagedClusterStorageProfileFileCsiDriver fileCsiDriver, ManagedClusterStorageProfileSnapshotController snapshotController, ManagedClusterStorageProfileBlobCsiDriver blobCsiDriver, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DiskCsiDriver = diskCsiDriver;
            FileCsiDriver = fileCsiDriver;
            SnapshotController = snapshotController;
            BlobCsiDriver = blobCsiDriver;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> AzureDisk CSI Driver settings for the storage profile. </summary>
        internal ManagedClusterStorageProfileDiskCsiDriver DiskCsiDriver { get; set; }

        /// <summary> AzureFile CSI Driver settings for the storage profile. </summary>
        internal ManagedClusterStorageProfileFileCsiDriver FileCsiDriver { get; set; }

        /// <summary> Snapshot Controller settings for the storage profile. </summary>
        internal ManagedClusterStorageProfileSnapshotController SnapshotController { get; set; }

        /// <summary> AzureBlob CSI Driver settings for the storage profile. </summary>
        internal ManagedClusterStorageProfileBlobCsiDriver BlobCsiDriver { get; set; }
    }
}
