// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ContainerService.Models
{
    public partial class ManagedClusterStorageProfile : IUtf8JsonSerializable, IJsonModel<ManagedClusterStorageProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ManagedClusterStorageProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ManagedClusterStorageProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterStorageProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedClusterStorageProfile)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DiskCsiDriver))
            {
                writer.WritePropertyName("diskCSIDriver"u8);
                writer.WriteObjectValue(DiskCsiDriver, options);
            }
            if (Optional.IsDefined(FileCsiDriver))
            {
                writer.WritePropertyName("fileCSIDriver"u8);
                writer.WriteObjectValue(FileCsiDriver, options);
            }
            if (Optional.IsDefined(SnapshotController))
            {
                writer.WritePropertyName("snapshotController"u8);
                writer.WriteObjectValue(SnapshotController, options);
            }
            if (Optional.IsDefined(BlobCsiDriver))
            {
                writer.WritePropertyName("blobCSIDriver"u8);
                writer.WriteObjectValue(BlobCsiDriver, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ManagedClusterStorageProfile IJsonModel<ManagedClusterStorageProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterStorageProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedClusterStorageProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeManagedClusterStorageProfile(document.RootElement, options);
        }

        internal static ManagedClusterStorageProfile DeserializeManagedClusterStorageProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ManagedClusterStorageProfileDiskCsiDriver diskCsiDriver = default;
            ManagedClusterStorageProfileFileCsiDriver fileCsiDriver = default;
            ManagedClusterStorageProfileSnapshotController snapshotController = default;
            ManagedClusterStorageProfileBlobCsiDriver blobCsiDriver = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("diskCSIDriver"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskCsiDriver = ManagedClusterStorageProfileDiskCsiDriver.DeserializeManagedClusterStorageProfileDiskCsiDriver(property.Value, options);
                    continue;
                }
                if (property.NameEquals("fileCSIDriver"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fileCsiDriver = ManagedClusterStorageProfileFileCsiDriver.DeserializeManagedClusterStorageProfileFileCsiDriver(property.Value, options);
                    continue;
                }
                if (property.NameEquals("snapshotController"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snapshotController = ManagedClusterStorageProfileSnapshotController.DeserializeManagedClusterStorageProfileSnapshotController(property.Value, options);
                    continue;
                }
                if (property.NameEquals("blobCSIDriver"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    blobCsiDriver = ManagedClusterStorageProfileBlobCsiDriver.DeserializeManagedClusterStorageProfileBlobCsiDriver(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ManagedClusterStorageProfile(diskCsiDriver, fileCsiDriver, snapshotController, blobCsiDriver, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  diskCSIDriver: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(DiskCsiDriver))
                {
                    builder.Append("  diskCSIDriver: ");
                    BicepSerializationHelpers.AppendChildObject(builder, DiskCsiDriver, options, 2, false, "  diskCSIDriver: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fileCSIDriver: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(FileCsiDriver))
                {
                    builder.Append("  fileCSIDriver: ");
                    BicepSerializationHelpers.AppendChildObject(builder, FileCsiDriver, options, 2, false, "  fileCSIDriver: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  snapshotController: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(SnapshotController))
                {
                    builder.Append("  snapshotController: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SnapshotController, options, 2, false, "  snapshotController: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("IsEnabled", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  blobCSIDriver: ");
                builder.AppendLine("{");
                builder.Append("    enabled: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(BlobCsiDriver))
                {
                    builder.Append("  blobCSIDriver: ");
                    BicepSerializationHelpers.AppendChildObject(builder, BlobCsiDriver, options, 2, false, "  blobCSIDriver: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ManagedClusterStorageProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterStorageProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ManagedClusterStorageProfile)} does not support writing '{options.Format}' format.");
            }
        }

        ManagedClusterStorageProfile IPersistableModel<ManagedClusterStorageProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterStorageProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeManagedClusterStorageProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ManagedClusterStorageProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ManagedClusterStorageProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
