// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> If not specified, the default is 'Free'. See [AKS Pricing Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details. </summary>
    public readonly partial struct ManagedClusterSkuTier : IEquatable<ManagedClusterSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PremiumValue = "Premium";
        private const string StandardValue = "Standard";
        private const string FreeValue = "Free";

        /// <summary> Cluster has premium capabilities in addition to all of the capabilities included in 'Standard'. Premium enables selection of LongTermSupport (aka.ms/aks/lts) for certain Kubernetes versions. </summary>
        public static ManagedClusterSkuTier Premium { get; } = new ManagedClusterSkuTier(PremiumValue);
        /// <summary> Recommended for mission-critical and production workloads. Includes Kubernetes control plane autoscaling, workload-intensive testing, and up to 5,000 nodes per cluster. Guarantees 99.95% availability of the Kubernetes API server endpoint for clusters that use Availability Zones and 99.9% of availability for clusters that don't use Availability Zones. </summary>
        public static ManagedClusterSkuTier Standard { get; } = new ManagedClusterSkuTier(StandardValue);
        /// <summary> The cluster management is free, but charged for VM, storage, and networking usage. Best for experimenting, learning, simple testing, or workloads with fewer than 10 nodes. Not recommended for production use cases. </summary>
        public static ManagedClusterSkuTier Free { get; } = new ManagedClusterSkuTier(FreeValue);
        /// <summary> Determines if two <see cref="ManagedClusterSkuTier"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterSkuTier left, ManagedClusterSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterSkuTier"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterSkuTier left, ManagedClusterSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterSkuTier"/>. </summary>
        public static implicit operator ManagedClusterSkuTier(string value) => new ManagedClusterSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
