// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The current provisioning state of the pod identity. </summary>
    public readonly partial struct ManagedClusterPodIdentityProvisioningState : IEquatable<ManagedClusterPodIdentityProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterPodIdentityProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterPodIdentityProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AssignedValue = "Assigned";
        private const string CanceledValue = "Canceled";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";

        /// <summary> Assigned. </summary>
        public static ManagedClusterPodIdentityProvisioningState Assigned { get; } = new ManagedClusterPodIdentityProvisioningState(AssignedValue);
        /// <summary> Canceled. </summary>
        public static ManagedClusterPodIdentityProvisioningState Canceled { get; } = new ManagedClusterPodIdentityProvisioningState(CanceledValue);
        /// <summary> Deleting. </summary>
        public static ManagedClusterPodIdentityProvisioningState Deleting { get; } = new ManagedClusterPodIdentityProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static ManagedClusterPodIdentityProvisioningState Failed { get; } = new ManagedClusterPodIdentityProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static ManagedClusterPodIdentityProvisioningState Succeeded { get; } = new ManagedClusterPodIdentityProvisioningState(SucceededValue);
        /// <summary> Updating. </summary>
        public static ManagedClusterPodIdentityProvisioningState Updating { get; } = new ManagedClusterPodIdentityProvisioningState(UpdatingValue);
        /// <summary> Determines if two <see cref="ManagedClusterPodIdentityProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterPodIdentityProvisioningState left, ManagedClusterPodIdentityProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterPodIdentityProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterPodIdentityProvisioningState left, ManagedClusterPodIdentityProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterPodIdentityProvisioningState"/>. </summary>
        public static implicit operator ManagedClusterPodIdentityProvisioningState(string value) => new ManagedClusterPodIdentityProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterPodIdentityProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterPodIdentityProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
