// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Manner in which the OS on your nodes is updated. The default is NodeImage. </summary>
    public readonly partial struct ManagedClusterNodeOSUpgradeChannel : IEquatable<ManagedClusterNodeOSUpgradeChannel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterNodeOSUpgradeChannel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedClusterNodeOSUpgradeChannel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string UnmanagedValue = "Unmanaged";
        private const string NodeImageValue = "NodeImage";

        /// <summary> No attempt to update your machines OS will be made either by OS or by rolling VHDs. This means you are responsible for your security updates. </summary>
        public static ManagedClusterNodeOSUpgradeChannel None { get; } = new ManagedClusterNodeOSUpgradeChannel(NoneValue);
        /// <summary> OS updates will be applied automatically through the OS built-in patching infrastructure. Newly scaled in machines will be unpatched initially and will be patched at some point by the OS's infrastructure. Behavior of this option depends on the OS in question. Ubuntu and Mariner apply security patches through unattended upgrade roughly once a day around 06:00 UTC. Windows does not apply security patches automatically and so for them this option is equivalent to None till further notice. </summary>
        public static ManagedClusterNodeOSUpgradeChannel Unmanaged { get; } = new ManagedClusterNodeOSUpgradeChannel(UnmanagedValue);
        /// <summary> AKS will update the nodes with a newly patched VHD containing security fixes and bugfixes on a weekly cadence. With the VHD update machines will be rolling reimaged to that VHD following maintenance windows and surge settings. No extra VHD cost is incurred when choosing this option as AKS hosts the images. </summary>
        public static ManagedClusterNodeOSUpgradeChannel NodeImage { get; } = new ManagedClusterNodeOSUpgradeChannel(NodeImageValue);
        /// <summary> Determines if two <see cref="ManagedClusterNodeOSUpgradeChannel"/> values are the same. </summary>
        public static bool operator ==(ManagedClusterNodeOSUpgradeChannel left, ManagedClusterNodeOSUpgradeChannel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedClusterNodeOSUpgradeChannel"/> values are not the same. </summary>
        public static bool operator !=(ManagedClusterNodeOSUpgradeChannel left, ManagedClusterNodeOSUpgradeChannel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedClusterNodeOSUpgradeChannel"/>. </summary>
        public static implicit operator ManagedClusterNodeOSUpgradeChannel(string value) => new ManagedClusterNodeOSUpgradeChannel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedClusterNodeOSUpgradeChannel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedClusterNodeOSUpgradeChannel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
