// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Properties for the container service agent pool profile. </summary>
    public partial class ManagedClusterAgentPoolProfileProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterAgentPoolProfileProperties"/>. </summary>
        public ManagedClusterAgentPoolProfileProperties()
        {
            AvailabilityZones = new ChangeTrackingList<string>();
            Tags = new ChangeTrackingDictionary<string, string>();
            NodeLabels = new ChangeTrackingDictionary<string, string>();
            NodeTaints = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedClusterAgentPoolProfileProperties"/>. </summary>
        /// <param name="count"> Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1. </param>
        /// <param name="vmSize"> VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions. </param>
        /// <param name="osDiskSizeInGB"> OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified. </param>
        /// <param name="osDiskType"> The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os). </param>
        /// <param name="kubeletDiskType"> Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage. </param>
        /// <param name="workloadRuntime"> Determines the type of workload a node can run. </param>
        /// <param name="vnetSubnetId"> If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}. </param>
        /// <param name="podSubnetId"> If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}. </param>
        /// <param name="maxPods"> The maximum number of pods that can run on a node. </param>
        /// <param name="osType"> The operating system type. The default is Linux. </param>
        /// <param name="osSku"> Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows. </param>
        /// <param name="maxCount"> The maximum number of nodes for auto-scaling. </param>
        /// <param name="minCount"> The minimum number of nodes for auto-scaling. </param>
        /// <param name="enableAutoScaling"> Whether to enable auto-scaler. </param>
        /// <param name="scaleDownMode"> This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete. </param>
        /// <param name="agentPoolType"> The type of Agent Pool. </param>
        /// <param name="mode"> A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools. </param>
        /// <param name="orchestratorVersion"> Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool). </param>
        /// <param name="currentOrchestratorVersion"> If orchestratorVersion is a fully specified version &lt;major.minor.patch&gt;, this field will be exactly equal to it. If orchestratorVersion is &lt;major.minor&gt;, this field will contain the full &lt;major.minor.patch&gt; version being used. </param>
        /// <param name="nodeImageVersion"> The version of node image. </param>
        /// <param name="upgradeSettings"> Settings for upgrading the agentpool. </param>
        /// <param name="provisioningState"> The current deployment or provisioning state. </param>
        /// <param name="powerState"> When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded. </param>
        /// <param name="availabilityZones"> The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'. </param>
        /// <param name="enableNodePublicIP"> Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false. </param>
        /// <param name="nodePublicIPPrefixId"> This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}. </param>
        /// <param name="scaleSetPriority"> The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'. </param>
        /// <param name="scaleSetEvictionPolicy"> This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'. </param>
        /// <param name="spotMaxPrice"> Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing). </param>
        /// <param name="tags"> The tags to be persisted on the agent pool virtual machine scale set. </param>
        /// <param name="nodeLabels"> The node labels to be persisted across all nodes in agent pool. </param>
        /// <param name="nodeTaints"> The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule. </param>
        /// <param name="proximityPlacementGroupId"> The ID for Proximity Placement Group. </param>
        /// <param name="kubeletConfig"> The Kubelet configuration on the agent pool nodes. </param>
        /// <param name="linuxOSConfig"> The OS configuration of Linux agent nodes. </param>
        /// <param name="enableEncryptionAtHost"> This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption. </param>
        /// <param name="enableUltraSsd"> Whether to enable UltraSSD. </param>
        /// <param name="enableFips"> See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details. </param>
        /// <param name="gpuInstanceProfile"> GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. </param>
        /// <param name="creationData"> CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot. </param>
        /// <param name="capacityReservationGroupId"> AKS will associate the specified agent pool with the Capacity Reservation Group. </param>
        /// <param name="hostGroupId"> This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts). </param>
        /// <param name="networkProfile"> Network-related settings of an agent pool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedClusterAgentPoolProfileProperties(int? count, string vmSize, int? osDiskSizeInGB, ContainerServiceOSDiskType? osDiskType, KubeletDiskType? kubeletDiskType, WorkloadRuntime? workloadRuntime, ResourceIdentifier vnetSubnetId, ResourceIdentifier podSubnetId, int? maxPods, ContainerServiceOSType? osType, ContainerServiceOSSku? osSku, int? maxCount, int? minCount, bool? enableAutoScaling, ScaleDownMode? scaleDownMode, AgentPoolType? agentPoolType, AgentPoolMode? mode, string orchestratorVersion, string currentOrchestratorVersion, string nodeImageVersion, AgentPoolUpgradeSettings upgradeSettings, string provisioningState, ContainerServicePowerState powerState, IList<string> availabilityZones, bool? enableNodePublicIP, ResourceIdentifier nodePublicIPPrefixId, ScaleSetPriority? scaleSetPriority, ScaleSetEvictionPolicy? scaleSetEvictionPolicy, float? spotMaxPrice, IDictionary<string, string> tags, IDictionary<string, string> nodeLabels, IList<string> nodeTaints, ResourceIdentifier proximityPlacementGroupId, KubeletConfig kubeletConfig, LinuxOSConfig linuxOSConfig, bool? enableEncryptionAtHost, bool? enableUltraSsd, bool? enableFips, GpuInstanceProfile? gpuInstanceProfile, ContainerServiceCreationData creationData, ResourceIdentifier capacityReservationGroupId, ResourceIdentifier hostGroupId, AgentPoolNetworkProfile networkProfile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Count = count;
            VmSize = vmSize;
            OSDiskSizeInGB = osDiskSizeInGB;
            OSDiskType = osDiskType;
            KubeletDiskType = kubeletDiskType;
            WorkloadRuntime = workloadRuntime;
            VnetSubnetId = vnetSubnetId;
            PodSubnetId = podSubnetId;
            MaxPods = maxPods;
            OSType = osType;
            OSSku = osSku;
            MaxCount = maxCount;
            MinCount = minCount;
            EnableAutoScaling = enableAutoScaling;
            ScaleDownMode = scaleDownMode;
            AgentPoolType = agentPoolType;
            Mode = mode;
            OrchestratorVersion = orchestratorVersion;
            CurrentOrchestratorVersion = currentOrchestratorVersion;
            NodeImageVersion = nodeImageVersion;
            UpgradeSettings = upgradeSettings;
            ProvisioningState = provisioningState;
            PowerState = powerState;
            AvailabilityZones = availabilityZones;
            EnableNodePublicIP = enableNodePublicIP;
            NodePublicIPPrefixId = nodePublicIPPrefixId;
            ScaleSetPriority = scaleSetPriority;
            ScaleSetEvictionPolicy = scaleSetEvictionPolicy;
            SpotMaxPrice = spotMaxPrice;
            Tags = tags;
            NodeLabels = nodeLabels;
            NodeTaints = nodeTaints;
            ProximityPlacementGroupId = proximityPlacementGroupId;
            KubeletConfig = kubeletConfig;
            LinuxOSConfig = linuxOSConfig;
            EnableEncryptionAtHost = enableEncryptionAtHost;
            EnableUltraSsd = enableUltraSsd;
            EnableFips = enableFips;
            GpuInstanceProfile = gpuInstanceProfile;
            CreationData = creationData;
            CapacityReservationGroupId = capacityReservationGroupId;
            HostGroupId = hostGroupId;
            NetworkProfile = networkProfile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1. </summary>
        [WirePath("count")]
        public int? Count { get; set; }
        /// <summary> VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions. </summary>
        [WirePath("vmSize")]
        public string VmSize { get; set; }
        /// <summary> OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified. </summary>
        [WirePath("osDiskSizeGB")]
        public int? OSDiskSizeInGB { get; set; }
        /// <summary> The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os). </summary>
        [WirePath("osDiskType")]
        public ContainerServiceOSDiskType? OSDiskType { get; set; }
        /// <summary> Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage. </summary>
        [WirePath("kubeletDiskType")]
        public KubeletDiskType? KubeletDiskType { get; set; }
        /// <summary> Determines the type of workload a node can run. </summary>
        [WirePath("workloadRuntime")]
        public WorkloadRuntime? WorkloadRuntime { get; set; }
        /// <summary> If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}. </summary>
        [WirePath("vnetSubnetID")]
        public ResourceIdentifier VnetSubnetId { get; set; }
        /// <summary> If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}. </summary>
        [WirePath("podSubnetID")]
        public ResourceIdentifier PodSubnetId { get; set; }
        /// <summary> The maximum number of pods that can run on a node. </summary>
        [WirePath("maxPods")]
        public int? MaxPods { get; set; }
        /// <summary> The operating system type. The default is Linux. </summary>
        [WirePath("osType")]
        public ContainerServiceOSType? OSType { get; set; }
        /// <summary> Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows. </summary>
        [WirePath("osSKU")]
        public ContainerServiceOSSku? OSSku { get; set; }
        /// <summary> The maximum number of nodes for auto-scaling. </summary>
        [WirePath("maxCount")]
        public int? MaxCount { get; set; }
        /// <summary> The minimum number of nodes for auto-scaling. </summary>
        [WirePath("minCount")]
        public int? MinCount { get; set; }
        /// <summary> Whether to enable auto-scaler. </summary>
        [WirePath("enableAutoScaling")]
        public bool? EnableAutoScaling { get; set; }
        /// <summary> This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete. </summary>
        [WirePath("scaleDownMode")]
        public ScaleDownMode? ScaleDownMode { get; set; }
        /// <summary> The type of Agent Pool. </summary>
        [WirePath("type")]
        public AgentPoolType? AgentPoolType { get; set; }
        /// <summary> A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools. </summary>
        [WirePath("mode")]
        public AgentPoolMode? Mode { get; set; }
        /// <summary> Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool). </summary>
        [WirePath("orchestratorVersion")]
        public string OrchestratorVersion { get; set; }
        /// <summary> If orchestratorVersion is a fully specified version &lt;major.minor.patch&gt;, this field will be exactly equal to it. If orchestratorVersion is &lt;major.minor&gt;, this field will contain the full &lt;major.minor.patch&gt; version being used. </summary>
        [WirePath("currentOrchestratorVersion")]
        public string CurrentOrchestratorVersion { get; }
        /// <summary> The version of node image. </summary>
        [WirePath("nodeImageVersion")]
        public string NodeImageVersion { get; }
        /// <summary> Settings for upgrading the agentpool. </summary>
        [WirePath("upgradeSettings")]
        public AgentPoolUpgradeSettings UpgradeSettings { get; set; }
        /// <summary> The current deployment or provisioning state. </summary>
        [WirePath("provisioningState")]
        public string ProvisioningState { get; }
        /// <summary> When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded. </summary>
        internal ContainerServicePowerState PowerState { get; set; }
        /// <summary> Tells whether the cluster is Running or Stopped. </summary>
        [WirePath("powerState.code")]
        public ContainerServiceStateCode? PowerStateCode
        {
            get => PowerState is null ? default : PowerState.Code;
            set
            {
                if (PowerState is null)
                    PowerState = new ContainerServicePowerState();
                PowerState.Code = value;
            }
        }

        /// <summary> The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'. </summary>
        [WirePath("availabilityZones")]
        public IList<string> AvailabilityZones { get; }
        /// <summary> Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false. </summary>
        [WirePath("enableNodePublicIP")]
        public bool? EnableNodePublicIP { get; set; }
        /// <summary> This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}. </summary>
        [WirePath("nodePublicIPPrefixID")]
        public ResourceIdentifier NodePublicIPPrefixId { get; set; }
        /// <summary> The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'. </summary>
        [WirePath("scaleSetPriority")]
        public ScaleSetPriority? ScaleSetPriority { get; set; }
        /// <summary> This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'. </summary>
        [WirePath("scaleSetEvictionPolicy")]
        public ScaleSetEvictionPolicy? ScaleSetEvictionPolicy { get; set; }
        /// <summary> Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing). </summary>
        [WirePath("spotMaxPrice")]
        public float? SpotMaxPrice { get; set; }
        /// <summary> The tags to be persisted on the agent pool virtual machine scale set. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> The node labels to be persisted across all nodes in agent pool. </summary>
        [WirePath("nodeLabels")]
        public IDictionary<string, string> NodeLabels { get; }
        /// <summary> The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule. </summary>
        [WirePath("nodeTaints")]
        public IList<string> NodeTaints { get; }
        /// <summary> The ID for Proximity Placement Group. </summary>
        [WirePath("proximityPlacementGroupID")]
        public ResourceIdentifier ProximityPlacementGroupId { get; set; }
        /// <summary> The Kubelet configuration on the agent pool nodes. </summary>
        [WirePath("kubeletConfig")]
        public KubeletConfig KubeletConfig { get; set; }
        /// <summary> The OS configuration of Linux agent nodes. </summary>
        [WirePath("linuxOSConfig")]
        public LinuxOSConfig LinuxOSConfig { get; set; }
        /// <summary> This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption. </summary>
        [WirePath("enableEncryptionAtHost")]
        public bool? EnableEncryptionAtHost { get; set; }
        /// <summary> Whether to enable UltraSSD. </summary>
        [WirePath("enableUltraSSD")]
        public bool? EnableUltraSsd { get; set; }
        /// <summary> See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details. </summary>
        [WirePath("enableFIPS")]
        public bool? EnableFips { get; set; }
        /// <summary> GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. </summary>
        [WirePath("gpuInstanceProfile")]
        public GpuInstanceProfile? GpuInstanceProfile { get; set; }
        /// <summary> CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot. </summary>
        internal ContainerServiceCreationData CreationData { get; set; }
        /// <summary> This is the ARM ID of the source object to be used to create the target object. </summary>
        [WirePath("creationData.sourceResourceId")]
        public ResourceIdentifier CreationDataSourceResourceId
        {
            get => CreationData is null ? default : CreationData.SourceResourceId;
            set
            {
                if (CreationData is null)
                    CreationData = new ContainerServiceCreationData();
                CreationData.SourceResourceId = value;
            }
        }

        /// <summary> AKS will associate the specified agent pool with the Capacity Reservation Group. </summary>
        [WirePath("capacityReservationGroupID")]
        public ResourceIdentifier CapacityReservationGroupId { get; set; }
        /// <summary> This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts). </summary>
        [WirePath("hostGroupID")]
        public ResourceIdentifier HostGroupId { get; set; }
        /// <summary> Network-related settings of an agent pool. </summary>
        [WirePath("networkProfile")]
        public AgentPoolNetworkProfile NetworkProfile { get; set; }
    }
}
