// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ContainerService.Models
{
    public partial class ManagedClusterAgentPoolProfile : IUtf8JsonSerializable, IJsonModel<ManagedClusterAgentPoolProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ManagedClusterAgentPoolProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ManagedClusterAgentPoolProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterAgentPoolProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedClusterAgentPoolProfile)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
        }

        ManagedClusterAgentPoolProfile IJsonModel<ManagedClusterAgentPoolProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterAgentPoolProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ManagedClusterAgentPoolProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeManagedClusterAgentPoolProfile(document.RootElement, options);
        }

        internal static ManagedClusterAgentPoolProfile DeserializeManagedClusterAgentPoolProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            int? count = default;
            string vmSize = default;
            int? osDiskSizeGB = default;
            ContainerServiceOSDiskType? osDiskType = default;
            KubeletDiskType? kubeletDiskType = default;
            WorkloadRuntime? workloadRuntime = default;
            ResourceIdentifier vnetSubnetId = default;
            ResourceIdentifier podSubnetId = default;
            int? maxPods = default;
            ContainerServiceOSType? osType = default;
            ContainerServiceOSSku? osSku = default;
            int? maxCount = default;
            int? minCount = default;
            bool? enableAutoScaling = default;
            ScaleDownMode? scaleDownMode = default;
            AgentPoolType? type = default;
            AgentPoolMode? mode = default;
            string orchestratorVersion = default;
            string currentOrchestratorVersion = default;
            string nodeImageVersion = default;
            AgentPoolUpgradeSettings upgradeSettings = default;
            string provisioningState = default;
            ContainerServicePowerState powerState = default;
            IList<string> availabilityZones = default;
            bool? enableNodePublicIP = default;
            ResourceIdentifier nodePublicIPPrefixId = default;
            ScaleSetPriority? scaleSetPriority = default;
            ScaleSetEvictionPolicy? scaleSetEvictionPolicy = default;
            float? spotMaxPrice = default;
            IDictionary<string, string> tags = default;
            IDictionary<string, string> nodeLabels = default;
            IList<string> nodeTaints = default;
            ResourceIdentifier proximityPlacementGroupId = default;
            KubeletConfig kubeletConfig = default;
            LinuxOSConfig linuxOSConfig = default;
            bool? enableEncryptionAtHost = default;
            bool? enableUltraSsd = default;
            bool? enableFIPS = default;
            GpuInstanceProfile? gpuInstanceProfile = default;
            ContainerServiceCreationData creationData = default;
            ResourceIdentifier capacityReservationGroupId = default;
            ResourceIdentifier hostGroupId = default;
            AgentPoolNetworkProfile networkProfile = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("count"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    count = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("vmSize"u8))
                {
                    vmSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("osDiskSizeGB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    osDiskSizeGB = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("osDiskType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    osDiskType = new ContainerServiceOSDiskType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("kubeletDiskType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kubeletDiskType = new KubeletDiskType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("workloadRuntime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    workloadRuntime = new WorkloadRuntime(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("vnetSubnetID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    vnetSubnetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("podSubnetID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    podSubnetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("maxPods"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxPods = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("osType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    osType = new ContainerServiceOSType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("osSKU"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    osSku = new ContainerServiceOSSku(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("maxCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("enableAutoScaling"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableAutoScaling = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("scaleDownMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scaleDownMode = new ScaleDownMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new AgentPoolType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("mode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mode = new AgentPoolMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("orchestratorVersion"u8))
                {
                    orchestratorVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("currentOrchestratorVersion"u8))
                {
                    currentOrchestratorVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nodeImageVersion"u8))
                {
                    nodeImageVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("upgradeSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    upgradeSettings = AgentPoolUpgradeSettings.DeserializeAgentPoolUpgradeSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    provisioningState = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("powerState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    powerState = ContainerServicePowerState.DeserializeContainerServicePowerState(property.Value, options);
                    continue;
                }
                if (property.NameEquals("availabilityZones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    availabilityZones = array;
                    continue;
                }
                if (property.NameEquals("enableNodePublicIP"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableNodePublicIP = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("nodePublicIPPrefixID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nodePublicIPPrefixId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scaleSetPriority"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scaleSetPriority = new ScaleSetPriority(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scaleSetEvictionPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scaleSetEvictionPolicy = new ScaleSetEvictionPolicy(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("spotMaxPrice"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    spotMaxPrice = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("nodeLabels"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    nodeLabels = dictionary;
                    continue;
                }
                if (property.NameEquals("nodeTaints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    nodeTaints = array;
                    continue;
                }
                if (property.NameEquals("proximityPlacementGroupID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    proximityPlacementGroupId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("kubeletConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kubeletConfig = KubeletConfig.DeserializeKubeletConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("linuxOSConfig"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    linuxOSConfig = LinuxOSConfig.DeserializeLinuxOSConfig(property.Value, options);
                    continue;
                }
                if (property.NameEquals("enableEncryptionAtHost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableEncryptionAtHost = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("enableUltraSSD"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableUltraSsd = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("enableFIPS"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableFIPS = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("gpuInstanceProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    gpuInstanceProfile = new GpuInstanceProfile(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("creationData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creationData = ContainerServiceCreationData.DeserializeContainerServiceCreationData(property.Value, options);
                    continue;
                }
                if (property.NameEquals("capacityReservationGroupID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    capacityReservationGroupId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("hostGroupID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hostGroupId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("networkProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    networkProfile = AgentPoolNetworkProfile.DeserializeAgentPoolNetworkProfile(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ManagedClusterAgentPoolProfile(
                count,
                vmSize,
                osDiskSizeGB,
                osDiskType,
                kubeletDiskType,
                workloadRuntime,
                vnetSubnetId,
                podSubnetId,
                maxPods,
                osType,
                osSku,
                maxCount,
                minCount,
                enableAutoScaling,
                scaleDownMode,
                type,
                mode,
                orchestratorVersion,
                currentOrchestratorVersion,
                nodeImageVersion,
                upgradeSettings,
                provisioningState,
                powerState,
                availabilityZones ?? new ChangeTrackingList<string>(),
                enableNodePublicIP,
                nodePublicIPPrefixId,
                scaleSetPriority,
                scaleSetEvictionPolicy,
                spotMaxPrice,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                nodeLabels ?? new ChangeTrackingDictionary<string, string>(),
                nodeTaints ?? new ChangeTrackingList<string>(),
                proximityPlacementGroupId,
                kubeletConfig,
                linuxOSConfig,
                enableEncryptionAtHost,
                enableUltraSsd,
                enableFIPS,
                gpuInstanceProfile,
                creationData,
                capacityReservationGroupId,
                hostGroupId,
                networkProfile,
                serializedAdditionalRawData,
                name);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Count), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  count: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Count))
                {
                    builder.Append("  count: ");
                    builder.AppendLine($"{Count.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VmSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  vmSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VmSize))
                {
                    builder.Append("  vmSize: ");
                    if (VmSize.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{VmSize}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{VmSize}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSDiskSizeInGB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  osDiskSizeGB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSDiskSizeInGB))
                {
                    builder.Append("  osDiskSizeGB: ");
                    builder.AppendLine($"{OSDiskSizeInGB.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSDiskType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  osDiskType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSDiskType))
                {
                    builder.Append("  osDiskType: ");
                    builder.AppendLine($"'{OSDiskType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KubeletDiskType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kubeletDiskType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KubeletDiskType))
                {
                    builder.Append("  kubeletDiskType: ");
                    builder.AppendLine($"'{KubeletDiskType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WorkloadRuntime), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  workloadRuntime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WorkloadRuntime))
                {
                    builder.Append("  workloadRuntime: ");
                    builder.AppendLine($"'{WorkloadRuntime.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VnetSubnetId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  vnetSubnetID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VnetSubnetId))
                {
                    builder.Append("  vnetSubnetID: ");
                    builder.AppendLine($"'{VnetSubnetId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PodSubnetId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  podSubnetID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PodSubnetId))
                {
                    builder.Append("  podSubnetID: ");
                    builder.AppendLine($"'{PodSubnetId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxPods), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maxPods: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxPods))
                {
                    builder.Append("  maxPods: ");
                    builder.AppendLine($"{MaxPods.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  osType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSType))
                {
                    builder.Append("  osType: ");
                    builder.AppendLine($"'{OSType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSSku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  osSKU: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSSku))
                {
                    builder.Append("  osSKU: ");
                    builder.AppendLine($"'{OSSku.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maxCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxCount))
                {
                    builder.Append("  maxCount: ");
                    builder.AppendLine($"{MaxCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MinCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  minCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MinCount))
                {
                    builder.Append("  minCount: ");
                    builder.AppendLine($"{MinCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableAutoScaling), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableAutoScaling: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableAutoScaling))
                {
                    builder.Append("  enableAutoScaling: ");
                    var boolValue = EnableAutoScaling.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScaleDownMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  scaleDownMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScaleDownMode))
                {
                    builder.Append("  scaleDownMode: ");
                    builder.AppendLine($"'{ScaleDownMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AgentPoolType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  type: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AgentPoolType))
                {
                    builder.Append("  type: ");
                    builder.AppendLine($"'{AgentPoolType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Mode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  mode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Mode))
                {
                    builder.Append("  mode: ");
                    builder.AppendLine($"'{Mode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OrchestratorVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  orchestratorVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OrchestratorVersion))
                {
                    builder.Append("  orchestratorVersion: ");
                    if (OrchestratorVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OrchestratorVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OrchestratorVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentOrchestratorVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  currentOrchestratorVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentOrchestratorVersion))
                {
                    builder.Append("  currentOrchestratorVersion: ");
                    if (CurrentOrchestratorVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentOrchestratorVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentOrchestratorVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeImageVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nodeImageVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NodeImageVersion))
                {
                    builder.Append("  nodeImageVersion: ");
                    if (NodeImageVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NodeImageVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NodeImageVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UpgradeSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  upgradeSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UpgradeSettings))
                {
                    builder.Append("  upgradeSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UpgradeSettings, options, 2, false, "  upgradeSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("  provisioningState: ");
                    if (ProvisioningState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProvisioningState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProvisioningState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("PowerStateCode", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  powerState: ");
                builder.AppendLine("{");
                builder.Append("    code: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(PowerState))
                {
                    builder.Append("  powerState: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PowerState, options, 2, false, "  powerState: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AvailabilityZones), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  availabilityZones: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AvailabilityZones))
                {
                    if (AvailabilityZones.Any())
                    {
                        builder.Append("  availabilityZones: ");
                        builder.AppendLine("[");
                        foreach (var item in AvailabilityZones)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableNodePublicIP), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableNodePublicIP: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableNodePublicIP))
                {
                    builder.Append("  enableNodePublicIP: ");
                    var boolValue = EnableNodePublicIP.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodePublicIPPrefixId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nodePublicIPPrefixID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NodePublicIPPrefixId))
                {
                    builder.Append("  nodePublicIPPrefixID: ");
                    builder.AppendLine($"'{NodePublicIPPrefixId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScaleSetPriority), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  scaleSetPriority: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScaleSetPriority))
                {
                    builder.Append("  scaleSetPriority: ");
                    builder.AppendLine($"'{ScaleSetPriority.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScaleSetEvictionPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  scaleSetEvictionPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScaleSetEvictionPolicy))
                {
                    builder.Append("  scaleSetEvictionPolicy: ");
                    builder.AppendLine($"'{ScaleSetEvictionPolicy.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SpotMaxPrice), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  spotMaxPrice: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SpotMaxPrice))
                {
                    builder.Append("  spotMaxPrice: ");
                    builder.AppendLine($"'{SpotMaxPrice.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeLabels), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nodeLabels: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(NodeLabels))
                {
                    if (NodeLabels.Any())
                    {
                        builder.Append("  nodeLabels: ");
                        builder.AppendLine("{");
                        foreach (var item in NodeLabels)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeTaints), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nodeTaints: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(NodeTaints))
                {
                    if (NodeTaints.Any())
                    {
                        builder.Append("  nodeTaints: ");
                        builder.AppendLine("[");
                        foreach (var item in NodeTaints)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProximityPlacementGroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  proximityPlacementGroupID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProximityPlacementGroupId))
                {
                    builder.Append("  proximityPlacementGroupID: ");
                    builder.AppendLine($"'{ProximityPlacementGroupId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KubeletConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kubeletConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KubeletConfig))
                {
                    builder.Append("  kubeletConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, KubeletConfig, options, 2, false, "  kubeletConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LinuxOSConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  linuxOSConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LinuxOSConfig))
                {
                    builder.Append("  linuxOSConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LinuxOSConfig, options, 2, false, "  linuxOSConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableEncryptionAtHost), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableEncryptionAtHost: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableEncryptionAtHost))
                {
                    builder.Append("  enableEncryptionAtHost: ");
                    var boolValue = EnableEncryptionAtHost.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableUltraSsd), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableUltraSSD: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableUltraSsd))
                {
                    builder.Append("  enableUltraSSD: ");
                    var boolValue = EnableUltraSsd.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableFips), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableFIPS: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableFips))
                {
                    builder.Append("  enableFIPS: ");
                    var boolValue = EnableFips.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GpuInstanceProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  gpuInstanceProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GpuInstanceProfile))
                {
                    builder.Append("  gpuInstanceProfile: ");
                    builder.AppendLine($"'{GpuInstanceProfile.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("CreationDataSourceResourceId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  creationData: ");
                builder.AppendLine("{");
                builder.Append("    sourceResourceId: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(CreationData))
                {
                    builder.Append("  creationData: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CreationData, options, 2, false, "  creationData: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CapacityReservationGroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  capacityReservationGroupID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CapacityReservationGroupId))
                {
                    builder.Append("  capacityReservationGroupID: ");
                    builder.AppendLine($"'{CapacityReservationGroupId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HostGroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hostGroupID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HostGroupId))
                {
                    builder.Append("  hostGroupID: ");
                    builder.AppendLine($"'{HostGroupId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  networkProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkProfile))
                {
                    builder.Append("  networkProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, NetworkProfile, options, 2, false, "  networkProfile: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ManagedClusterAgentPoolProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterAgentPoolProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ManagedClusterAgentPoolProfile)} does not support writing '{options.Format}' format.");
            }
        }

        ManagedClusterAgentPoolProfile IPersistableModel<ManagedClusterAgentPoolProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ManagedClusterAgentPoolProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeManagedClusterAgentPoolProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ManagedClusterAgentPoolProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ManagedClusterAgentPoolProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
