// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> For more details see [managed AAD on AKS](https://docs.microsoft.com/azure/aks/managed-aad). </summary>
    public partial class ManagedClusterAadProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedClusterAadProfile"/>. </summary>
        public ManagedClusterAadProfile()
        {
            AdminGroupObjectIds = new ChangeTrackingList<Guid>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedClusterAadProfile"/>. </summary>
        /// <param name="isManagedAadEnabled"> Whether to enable managed AAD. </param>
        /// <param name="isAzureRbacEnabled"> Whether to enable Azure RBAC for Kubernetes authorization. </param>
        /// <param name="adminGroupObjectIds"> The list of AAD group object IDs that will have admin role of the cluster. </param>
        /// <param name="clientAppId"> (DEPRECATED) The client AAD application ID. Learn more at https://aka.ms/aks/aad-legacy. </param>
        /// <param name="serverAppId"> (DEPRECATED) The server AAD application ID. Learn more at https://aka.ms/aks/aad-legacy. </param>
        /// <param name="serverAppSecret"> (DEPRECATED) The server AAD application secret. Learn more at https://aka.ms/aks/aad-legacy. </param>
        /// <param name="tenantId"> The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedClusterAadProfile(bool? isManagedAadEnabled, bool? isAzureRbacEnabled, IList<Guid> adminGroupObjectIds, Guid? clientAppId, Guid? serverAppId, string serverAppSecret, Guid? tenantId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsManagedAadEnabled = isManagedAadEnabled;
            IsAzureRbacEnabled = isAzureRbacEnabled;
            AdminGroupObjectIds = adminGroupObjectIds;
            ClientAppId = clientAppId;
            ServerAppId = serverAppId;
            ServerAppSecret = serverAppSecret;
            TenantId = tenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Whether to enable managed AAD. </summary>
        [WirePath("managed")]
        public bool? IsManagedAadEnabled { get; set; }
        /// <summary> Whether to enable Azure RBAC for Kubernetes authorization. </summary>
        [WirePath("enableAzureRBAC")]
        public bool? IsAzureRbacEnabled { get; set; }
        /// <summary> The list of AAD group object IDs that will have admin role of the cluster. </summary>
        [WirePath("adminGroupObjectIDs")]
        public IList<Guid> AdminGroupObjectIds { get; }
        /// <summary> (DEPRECATED) The client AAD application ID. Learn more at https://aka.ms/aks/aad-legacy. </summary>
        [WirePath("clientAppID")]
        public Guid? ClientAppId { get; set; }
        /// <summary> (DEPRECATED) The server AAD application ID. Learn more at https://aka.ms/aks/aad-legacy. </summary>
        [WirePath("serverAppID")]
        public Guid? ServerAppId { get; set; }
        /// <summary> (DEPRECATED) The server AAD application secret. Learn more at https://aka.ms/aks/aad-legacy. </summary>
        [WirePath("serverAppSecret")]
        public string ServerAppSecret { get; set; }
        /// <summary> The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription. </summary>
        [WirePath("tenantID")]
        public Guid? TenantId { get; set; }
    }
}
