// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ContainerService.Models
{
    public partial class KubeletConfig : IUtf8JsonSerializable, IJsonModel<KubeletConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KubeletConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KubeletConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubeletConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubeletConfig)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CpuManagerPolicy))
            {
                writer.WritePropertyName("cpuManagerPolicy"u8);
                writer.WriteStringValue(CpuManagerPolicy);
            }
            if (Optional.IsDefined(IsCpuCfsQuotaEnabled))
            {
                writer.WritePropertyName("cpuCfsQuota"u8);
                writer.WriteBooleanValue(IsCpuCfsQuotaEnabled.Value);
            }
            if (Optional.IsDefined(CpuCfsQuotaPeriod))
            {
                writer.WritePropertyName("cpuCfsQuotaPeriod"u8);
                writer.WriteStringValue(CpuCfsQuotaPeriod);
            }
            if (Optional.IsDefined(ImageGcHighThreshold))
            {
                writer.WritePropertyName("imageGcHighThreshold"u8);
                writer.WriteNumberValue(ImageGcHighThreshold.Value);
            }
            if (Optional.IsDefined(ImageGcLowThreshold))
            {
                writer.WritePropertyName("imageGcLowThreshold"u8);
                writer.WriteNumberValue(ImageGcLowThreshold.Value);
            }
            if (Optional.IsDefined(TopologyManagerPolicy))
            {
                writer.WritePropertyName("topologyManagerPolicy"u8);
                writer.WriteStringValue(TopologyManagerPolicy);
            }
            if (Optional.IsCollectionDefined(AllowedUnsafeSysctls))
            {
                writer.WritePropertyName("allowedUnsafeSysctls"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedUnsafeSysctls)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(FailStartWithSwapOn))
            {
                writer.WritePropertyName("failSwapOn"u8);
                writer.WriteBooleanValue(FailStartWithSwapOn.Value);
            }
            if (Optional.IsDefined(ContainerLogMaxSizeInMB))
            {
                writer.WritePropertyName("containerLogMaxSizeMB"u8);
                writer.WriteNumberValue(ContainerLogMaxSizeInMB.Value);
            }
            if (Optional.IsDefined(ContainerLogMaxFiles))
            {
                writer.WritePropertyName("containerLogMaxFiles"u8);
                writer.WriteNumberValue(ContainerLogMaxFiles.Value);
            }
            if (Optional.IsDefined(PodMaxPids))
            {
                writer.WritePropertyName("podMaxPids"u8);
                writer.WriteNumberValue(PodMaxPids.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        KubeletConfig IJsonModel<KubeletConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubeletConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KubeletConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKubeletConfig(document.RootElement, options);
        }

        internal static KubeletConfig DeserializeKubeletConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string cpuManagerPolicy = default;
            bool? cpuCfsQuota = default;
            string cpuCfsQuotaPeriod = default;
            int? imageGcHighThreshold = default;
            int? imageGcLowThreshold = default;
            string topologyManagerPolicy = default;
            IList<string> allowedUnsafeSysctls = default;
            bool? failSwapOn = default;
            int? containerLogMaxSizeMB = default;
            int? containerLogMaxFiles = default;
            int? podMaxPids = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("cpuManagerPolicy"u8))
                {
                    cpuManagerPolicy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cpuCfsQuota"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cpuCfsQuota = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("cpuCfsQuotaPeriod"u8))
                {
                    cpuCfsQuotaPeriod = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("imageGcHighThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    imageGcHighThreshold = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("imageGcLowThreshold"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    imageGcLowThreshold = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("topologyManagerPolicy"u8))
                {
                    topologyManagerPolicy = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("allowedUnsafeSysctls"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    allowedUnsafeSysctls = array;
                    continue;
                }
                if (property.NameEquals("failSwapOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    failSwapOn = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("containerLogMaxSizeMB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    containerLogMaxSizeMB = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("containerLogMaxFiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    containerLogMaxFiles = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("podMaxPids"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    podMaxPids = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KubeletConfig(
                cpuManagerPolicy,
                cpuCfsQuota,
                cpuCfsQuotaPeriod,
                imageGcHighThreshold,
                imageGcLowThreshold,
                topologyManagerPolicy,
                allowedUnsafeSysctls ?? new ChangeTrackingList<string>(),
                failSwapOn,
                containerLogMaxSizeMB,
                containerLogMaxFiles,
                podMaxPids,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CpuManagerPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cpuManagerPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CpuManagerPolicy))
                {
                    builder.Append("  cpuManagerPolicy: ");
                    if (CpuManagerPolicy.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CpuManagerPolicy}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CpuManagerPolicy}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsCpuCfsQuotaEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cpuCfsQuota: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsCpuCfsQuotaEnabled))
                {
                    builder.Append("  cpuCfsQuota: ");
                    var boolValue = IsCpuCfsQuotaEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CpuCfsQuotaPeriod), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cpuCfsQuotaPeriod: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CpuCfsQuotaPeriod))
                {
                    builder.Append("  cpuCfsQuotaPeriod: ");
                    if (CpuCfsQuotaPeriod.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CpuCfsQuotaPeriod}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CpuCfsQuotaPeriod}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImageGcHighThreshold), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  imageGcHighThreshold: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImageGcHighThreshold))
                {
                    builder.Append("  imageGcHighThreshold: ");
                    builder.AppendLine($"{ImageGcHighThreshold.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImageGcLowThreshold), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  imageGcLowThreshold: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImageGcLowThreshold))
                {
                    builder.Append("  imageGcLowThreshold: ");
                    builder.AppendLine($"{ImageGcLowThreshold.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TopologyManagerPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  topologyManagerPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TopologyManagerPolicy))
                {
                    builder.Append("  topologyManagerPolicy: ");
                    if (TopologyManagerPolicy.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TopologyManagerPolicy}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TopologyManagerPolicy}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllowedUnsafeSysctls), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  allowedUnsafeSysctls: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AllowedUnsafeSysctls))
                {
                    if (AllowedUnsafeSysctls.Any())
                    {
                        builder.Append("  allowedUnsafeSysctls: ");
                        builder.AppendLine("[");
                        foreach (var item in AllowedUnsafeSysctls)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FailStartWithSwapOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  failSwapOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FailStartWithSwapOn))
                {
                    builder.Append("  failSwapOn: ");
                    var boolValue = FailStartWithSwapOn.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContainerLogMaxSizeInMB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  containerLogMaxSizeMB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContainerLogMaxSizeInMB))
                {
                    builder.Append("  containerLogMaxSizeMB: ");
                    builder.AppendLine($"{ContainerLogMaxSizeInMB.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContainerLogMaxFiles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  containerLogMaxFiles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContainerLogMaxFiles))
                {
                    builder.Append("  containerLogMaxFiles: ");
                    builder.AppendLine($"{ContainerLogMaxFiles.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PodMaxPids), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  podMaxPids: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PodMaxPids))
                {
                    builder.Append("  podMaxPids: ");
                    builder.AppendLine($"{PodMaxPids.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<KubeletConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubeletConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(KubeletConfig)} does not support writing '{options.Format}' format.");
            }
        }

        KubeletConfig IPersistableModel<KubeletConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KubeletConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKubeletConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KubeletConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KubeletConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
