// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The KubeConfigFormat. </summary>
    public readonly partial struct KubeConfigFormat : IEquatable<KubeConfigFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubeConfigFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubeConfigFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "azure";
        private const string ExecValue = "exec";

        /// <summary> Return azure auth-provider kubeconfig. This format is deprecated in v1.22 and will be fully removed in v1.26. See: https://aka.ms/k8s/changes-1-26. </summary>
        public static KubeConfigFormat Azure { get; } = new KubeConfigFormat(AzureValue);
        /// <summary> Return exec format kubeconfig. This format requires kubelogin binary in the path. </summary>
        public static KubeConfigFormat Exec { get; } = new KubeConfigFormat(ExecValue);
        /// <summary> Determines if two <see cref="KubeConfigFormat"/> values are the same. </summary>
        public static bool operator ==(KubeConfigFormat left, KubeConfigFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubeConfigFormat"/> values are not the same. </summary>
        public static bool operator !=(KubeConfigFormat left, KubeConfigFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubeConfigFormat"/>. </summary>
        public static implicit operator KubeConfigFormat(string value) => new KubeConfigFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubeConfigFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubeConfigFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
