// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Plugin certificates information for Service Mesh. </summary>
    public partial class IstioPluginCertificateAuthority
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IstioPluginCertificateAuthority"/>. </summary>
        public IstioPluginCertificateAuthority()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IstioPluginCertificateAuthority"/>. </summary>
        /// <param name="keyVaultId"> The resource ID of the Key Vault. </param>
        /// <param name="certObjectName"> Intermediate certificate object name in Azure Key Vault. </param>
        /// <param name="keyObjectName"> Intermediate certificate private key object name in Azure Key Vault. </param>
        /// <param name="rootCertObjectName"> Root certificate object name in Azure Key Vault. </param>
        /// <param name="certChainObjectName"> Certificate chain object name in Azure Key Vault. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IstioPluginCertificateAuthority(ResourceIdentifier keyVaultId, string certObjectName, string keyObjectName, string rootCertObjectName, string certChainObjectName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultId = keyVaultId;
            CertObjectName = certObjectName;
            KeyObjectName = keyObjectName;
            RootCertObjectName = rootCertObjectName;
            CertChainObjectName = certChainObjectName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource ID of the Key Vault. </summary>
        [WirePath("keyVaultId")]
        public ResourceIdentifier KeyVaultId { get; set; }
        /// <summary> Intermediate certificate object name in Azure Key Vault. </summary>
        [WirePath("certObjectName")]
        public string CertObjectName { get; set; }
        /// <summary> Intermediate certificate private key object name in Azure Key Vault. </summary>
        [WirePath("keyObjectName")]
        public string KeyObjectName { get; set; }
        /// <summary> Root certificate object name in Azure Key Vault. </summary>
        [WirePath("rootCertObjectName")]
        public string RootCertObjectName { get; set; }
        /// <summary> Certificate chain object name in Azure Key Vault. </summary>
        [WirePath("certChainObjectName")]
        public string CertChainObjectName { get; set; }
    }
}
