// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Istio ingress gateway configuration. For now, we support up to one external ingress gateway named `aks-istio-ingressgateway-external` and one internal ingress gateway named `aks-istio-ingressgateway-internal`. </summary>
    public partial class IstioIngressGateway
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IstioIngressGateway"/>. </summary>
        /// <param name="mode"> Mode of an ingress gateway. </param>
        /// <param name="isEnabled"> Whether to enable the ingress gateway. </param>
        public IstioIngressGateway(IstioIngressGatewayMode mode, bool isEnabled)
        {
            Mode = mode;
            IsEnabled = isEnabled;
        }

        /// <summary> Initializes a new instance of <see cref="IstioIngressGateway"/>. </summary>
        /// <param name="mode"> Mode of an ingress gateway. </param>
        /// <param name="isEnabled"> Whether to enable the ingress gateway. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IstioIngressGateway(IstioIngressGatewayMode mode, bool isEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Mode = mode;
            IsEnabled = isEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IstioIngressGateway"/> for deserialization. </summary>
        internal IstioIngressGateway()
        {
        }

        /// <summary> Mode of an ingress gateway. </summary>
        [WirePath("mode")]
        public IstioIngressGatewayMode Mode { get; set; }
        /// <summary> Whether to enable the ingress gateway. </summary>
        [WirePath("enabled")]
        public bool IsEnabled { get; set; }
    }
}
