// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU. </summary>
    public readonly partial struct GpuInstanceProfile : IEquatable<GpuInstanceProfile>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GpuInstanceProfile"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GpuInstanceProfile(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Mig1GValue = "MIG1g";
        private const string Mig2GValue = "MIG2g";
        private const string Mig3GValue = "MIG3g";
        private const string Mig4GValue = "MIG4g";
        private const string Mig7GValue = "MIG7g";

        /// <summary> MIG1g. </summary>
        public static GpuInstanceProfile Mig1G { get; } = new GpuInstanceProfile(Mig1GValue);
        /// <summary> MIG2g. </summary>
        public static GpuInstanceProfile Mig2G { get; } = new GpuInstanceProfile(Mig2GValue);
        /// <summary> MIG3g. </summary>
        public static GpuInstanceProfile Mig3G { get; } = new GpuInstanceProfile(Mig3GValue);
        /// <summary> MIG4g. </summary>
        public static GpuInstanceProfile Mig4G { get; } = new GpuInstanceProfile(Mig4GValue);
        /// <summary> MIG7g. </summary>
        public static GpuInstanceProfile Mig7G { get; } = new GpuInstanceProfile(Mig7GValue);
        /// <summary> Determines if two <see cref="GpuInstanceProfile"/> values are the same. </summary>
        public static bool operator ==(GpuInstanceProfile left, GpuInstanceProfile right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GpuInstanceProfile"/> values are not the same. </summary>
        public static bool operator !=(GpuInstanceProfile left, GpuInstanceProfile right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GpuInstanceProfile"/>. </summary>
        public static implicit operator GpuInstanceProfile(string value) => new GpuInstanceProfile(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GpuInstanceProfile other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GpuInstanceProfile other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
