// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> For schedules like: 'recur every day' or 'recur every 3 days'. </summary>
    internal partial class DailySchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DailySchedule"/>. </summary>
        /// <param name="intervalDays"> Specifies the number of days between each set of occurrences. </param>
        public DailySchedule(int intervalDays)
        {
            IntervalDays = intervalDays;
        }

        /// <summary> Initializes a new instance of <see cref="DailySchedule"/>. </summary>
        /// <param name="intervalDays"> Specifies the number of days between each set of occurrences. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DailySchedule(int intervalDays, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IntervalDays = intervalDays;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DailySchedule"/> for deserialization. </summary>
        internal DailySchedule()
        {
        }

        /// <summary> Specifies the number of days between each set of occurrences. </summary>
        [WirePath("intervalDays")]
        public int IntervalDays { get; set; }
    }
}
