// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The weekday enum. </summary>
    public readonly partial struct ContainerServiceWeekDay : IEquatable<ContainerServiceWeekDay>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceWeekDay"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceWeekDay(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SundayValue = "Sunday";
        private const string MondayValue = "Monday";
        private const string TuesdayValue = "Tuesday";
        private const string WednesdayValue = "Wednesday";
        private const string ThursdayValue = "Thursday";
        private const string FridayValue = "Friday";
        private const string SaturdayValue = "Saturday";

        /// <summary> Sunday. </summary>
        public static ContainerServiceWeekDay Sunday { get; } = new ContainerServiceWeekDay(SundayValue);
        /// <summary> Monday. </summary>
        public static ContainerServiceWeekDay Monday { get; } = new ContainerServiceWeekDay(MondayValue);
        /// <summary> Tuesday. </summary>
        public static ContainerServiceWeekDay Tuesday { get; } = new ContainerServiceWeekDay(TuesdayValue);
        /// <summary> Wednesday. </summary>
        public static ContainerServiceWeekDay Wednesday { get; } = new ContainerServiceWeekDay(WednesdayValue);
        /// <summary> Thursday. </summary>
        public static ContainerServiceWeekDay Thursday { get; } = new ContainerServiceWeekDay(ThursdayValue);
        /// <summary> Friday. </summary>
        public static ContainerServiceWeekDay Friday { get; } = new ContainerServiceWeekDay(FridayValue);
        /// <summary> Saturday. </summary>
        public static ContainerServiceWeekDay Saturday { get; } = new ContainerServiceWeekDay(SaturdayValue);
        /// <summary> Determines if two <see cref="ContainerServiceWeekDay"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceWeekDay left, ContainerServiceWeekDay right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceWeekDay"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceWeekDay left, ContainerServiceWeekDay right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceWeekDay"/>. </summary>
        public static implicit operator ContainerServiceWeekDay(string value) => new ContainerServiceWeekDay(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceWeekDay other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceWeekDay other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
