// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Tells whether the cluster is Running or Stopped. </summary>
    public readonly partial struct ContainerServiceStateCode : IEquatable<ContainerServiceStateCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceStateCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceStateCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string StoppedValue = "Stopped";

        /// <summary> The cluster is running. </summary>
        public static ContainerServiceStateCode Running { get; } = new ContainerServiceStateCode(RunningValue);
        /// <summary> The cluster is stopped. </summary>
        public static ContainerServiceStateCode Stopped { get; } = new ContainerServiceStateCode(StoppedValue);
        /// <summary> Determines if two <see cref="ContainerServiceStateCode"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceStateCode left, ContainerServiceStateCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceStateCode"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceStateCode left, ContainerServiceStateCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceStateCode"/>. </summary>
        public static implicit operator ContainerServiceStateCode(string value) => new ContainerServiceStateCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceStateCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceStateCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
