// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The private link service connection status. </summary>
    public readonly partial struct ContainerServicePrivateLinkServiceConnectionStatus : IEquatable<ContainerServicePrivateLinkServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServicePrivateLinkServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServicePrivateLinkServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Pending. </summary>
        public static ContainerServicePrivateLinkServiceConnectionStatus Pending { get; } = new ContainerServicePrivateLinkServiceConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static ContainerServicePrivateLinkServiceConnectionStatus Approved { get; } = new ContainerServicePrivateLinkServiceConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static ContainerServicePrivateLinkServiceConnectionStatus Rejected { get; } = new ContainerServicePrivateLinkServiceConnectionStatus(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static ContainerServicePrivateLinkServiceConnectionStatus Disconnected { get; } = new ContainerServicePrivateLinkServiceConnectionStatus(DisconnectedValue);
        /// <summary> Determines if two <see cref="ContainerServicePrivateLinkServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(ContainerServicePrivateLinkServiceConnectionStatus left, ContainerServicePrivateLinkServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServicePrivateLinkServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(ContainerServicePrivateLinkServiceConnectionStatus left, ContainerServicePrivateLinkServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServicePrivateLinkServiceConnectionStatus"/>. </summary>
        public static implicit operator ContainerServicePrivateLinkServiceConnectionStatus(string value) => new ContainerServicePrivateLinkServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServicePrivateLinkServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServicePrivateLinkServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
