// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows. </summary>
    public readonly partial struct ContainerServiceOSSku : IEquatable<ContainerServiceOSSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceOSSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceOSSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UbuntuValue = "Ubuntu";
        private const string AzureLinuxValue = "AzureLinux";
        private const string CblMarinerValue = "CBLMariner";
        private const string Windows2019Value = "Windows2019";
        private const string Windows2022Value = "Windows2022";

        /// <summary> Use Ubuntu as the OS for node images. </summary>
        public static ContainerServiceOSSku Ubuntu { get; } = new ContainerServiceOSSku(UbuntuValue);
        /// <summary> Use AzureLinux as the OS for node images. Azure Linux is a container-optimized Linux distro built by Microsoft, visit https://aka.ms/azurelinux for more information. </summary>
        public static ContainerServiceOSSku AzureLinux { get; } = new ContainerServiceOSSku(AzureLinuxValue);
        /// <summary> Deprecated OSSKU. Microsoft recommends that new deployments choose 'AzureLinux' instead. </summary>
        public static ContainerServiceOSSku CblMariner { get; } = new ContainerServiceOSSku(CblMarinerValue);
        /// <summary> Use Windows2019 as the OS for node images. Unsupported for system node pools. Windows2019 only supports Windows2019 containers; it cannot run Windows2022 containers and vice versa. </summary>
        public static ContainerServiceOSSku Windows2019 { get; } = new ContainerServiceOSSku(Windows2019Value);
        /// <summary> Use Windows2022 as the OS for node images. Unsupported for system node pools. Windows2022 only supports Windows2022 containers; it cannot run Windows2019 containers and vice versa. </summary>
        public static ContainerServiceOSSku Windows2022 { get; } = new ContainerServiceOSSku(Windows2022Value);
        /// <summary> Determines if two <see cref="ContainerServiceOSSku"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceOSSku left, ContainerServiceOSSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceOSSku"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceOSSku left, ContainerServiceOSSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceOSSku"/>. </summary>
        public static implicit operator ContainerServiceOSSku(string value) => new ContainerServiceOSSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceOSSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceOSSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
