// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os). </summary>
    public readonly partial struct ContainerServiceOSDiskType : IEquatable<ContainerServiceOSDiskType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceOSDiskType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceOSDiskType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManagedValue = "Managed";
        private const string EphemeralValue = "Ephemeral";

        /// <summary> Azure replicates the operating system disk for a virtual machine to Azure storage to avoid data loss should the VM need to be relocated to another host. Since containers aren't designed to have local state persisted, this behavior offers limited value while providing some drawbacks, including slower node provisioning and higher read/write latency. </summary>
        public static ContainerServiceOSDiskType Managed { get; } = new ContainerServiceOSDiskType(ManagedValue);
        /// <summary> Ephemeral OS disks are stored only on the host machine, just like a temporary disk. This provides lower read/write latency, along with faster node scaling and cluster upgrades. </summary>
        public static ContainerServiceOSDiskType Ephemeral { get; } = new ContainerServiceOSDiskType(EphemeralValue);
        /// <summary> Determines if two <see cref="ContainerServiceOSDiskType"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceOSDiskType left, ContainerServiceOSDiskType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceOSDiskType"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceOSDiskType left, ContainerServiceOSDiskType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceOSDiskType"/>. </summary>
        public static implicit operator ContainerServiceOSDiskType(string value) => new ContainerServiceOSDiskType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceOSDiskType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceOSDiskType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
