// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Network policy used for building the Kubernetes network. </summary>
    public readonly partial struct ContainerServiceNetworkPolicy : IEquatable<ContainerServiceNetworkPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceNetworkPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceNetworkPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CalicoValue = "calico";
        private const string AzureValue = "azure";
        private const string CiliumValue = "cilium";

        /// <summary> Use Calico network policies. See [differences between Azure and Calico policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities) for more information. </summary>
        public static ContainerServiceNetworkPolicy Calico { get; } = new ContainerServiceNetworkPolicy(CalicoValue);
        /// <summary> Use Azure network policies. See [differences between Azure and Calico policies](https://docs.microsoft.com/azure/aks/use-network-policies#differences-between-azure-and-calico-policies-and-their-capabilities) for more information. </summary>
        public static ContainerServiceNetworkPolicy Azure { get; } = new ContainerServiceNetworkPolicy(AzureValue);
        /// <summary> Use Cilium to enforce network policies. This requires networkDataplane to be 'cilium'. </summary>
        public static ContainerServiceNetworkPolicy Cilium { get; } = new ContainerServiceNetworkPolicy(CiliumValue);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkPolicy"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceNetworkPolicy left, ContainerServiceNetworkPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkPolicy"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceNetworkPolicy left, ContainerServiceNetworkPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceNetworkPolicy"/>. </summary>
        public static implicit operator ContainerServiceNetworkPolicy(string value) => new ContainerServiceNetworkPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceNetworkPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceNetworkPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
