// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The mode the network plugin should use. </summary>
    public readonly partial struct ContainerServiceNetworkPluginMode : IEquatable<ContainerServiceNetworkPluginMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceNetworkPluginMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceNetworkPluginMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OverlayValue = "overlay";

        /// <summary> Used with networkPlugin=azure, pods are given IPs from the PodCIDR address space but use Azure Routing Domains rather than Kubenet's method of route tables. For more information visit https://aka.ms/aks/azure-cni-overlay. </summary>
        public static ContainerServiceNetworkPluginMode Overlay { get; } = new ContainerServiceNetworkPluginMode(OverlayValue);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkPluginMode"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceNetworkPluginMode left, ContainerServiceNetworkPluginMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkPluginMode"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceNetworkPluginMode left, ContainerServiceNetworkPluginMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceNetworkPluginMode"/>. </summary>
        public static implicit operator ContainerServiceNetworkPluginMode(string value) => new ContainerServiceNetworkPluginMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceNetworkPluginMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceNetworkPluginMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
