// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Network plugin used for building the Kubernetes network. </summary>
    public readonly partial struct ContainerServiceNetworkPlugin : IEquatable<ContainerServiceNetworkPlugin>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceNetworkPlugin"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceNetworkPlugin(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "azure";
        private const string KubenetValue = "kubenet";
        private const string NoneValue = "none";

        /// <summary> Use the Azure CNI network plugin. See [Azure CNI (advanced) networking](https://docs.microsoft.com/azure/aks/concepts-network#azure-cni-advanced-networking) for more information. </summary>
        public static ContainerServiceNetworkPlugin Azure { get; } = new ContainerServiceNetworkPlugin(AzureValue);
        /// <summary> Use the Kubenet network plugin. See [Kubenet (basic) networking](https://docs.microsoft.com/azure/aks/concepts-network#kubenet-basic-networking) for more information. </summary>
        public static ContainerServiceNetworkPlugin Kubenet { get; } = new ContainerServiceNetworkPlugin(KubenetValue);
        /// <summary> No CNI plugin is pre-installed. See [BYO CNI](https://docs.microsoft.com/en-us/azure/aks/use-byo-cni) for more information. </summary>
        public static ContainerServiceNetworkPlugin None { get; } = new ContainerServiceNetworkPlugin(NoneValue);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkPlugin"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceNetworkPlugin left, ContainerServiceNetworkPlugin right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkPlugin"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceNetworkPlugin left, ContainerServiceNetworkPlugin right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceNetworkPlugin"/>. </summary>
        public static implicit operator ContainerServiceNetworkPlugin(string value) => new ContainerServiceNetworkPlugin(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceNetworkPlugin other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceNetworkPlugin other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
