// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> This cannot be specified if networkPlugin is anything other than 'azure'. </summary>
    public readonly partial struct ContainerServiceNetworkMode : IEquatable<ContainerServiceNetworkMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceNetworkMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceNetworkMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TransparentValue = "transparent";
        private const string BridgeValue = "bridge";

        /// <summary> No bridge is created. Intra-VM Pod to Pod communication is through IP routes created by Azure CNI. See [Transparent Mode](https://docs.microsoft.com/azure/aks/faq#transparent-mode) for more information. </summary>
        public static ContainerServiceNetworkMode Transparent { get; } = new ContainerServiceNetworkMode(TransparentValue);
        /// <summary> This is no longer supported. </summary>
        public static ContainerServiceNetworkMode Bridge { get; } = new ContainerServiceNetworkMode(BridgeValue);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkMode"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceNetworkMode left, ContainerServiceNetworkMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceNetworkMode"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceNetworkMode left, ContainerServiceNetworkMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceNetworkMode"/>. </summary>
        public static implicit operator ContainerServiceNetworkMode(string value) => new ContainerServiceNetworkMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceNetworkMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceNetworkMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
