// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> One and only one of the schedule types should be specified. Choose either 'daily', 'weekly', 'absoluteMonthly' or 'relativeMonthly' for your maintenance schedule. </summary>
    public partial class ContainerServiceMaintenanceSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceMaintenanceSchedule"/>. </summary>
        public ContainerServiceMaintenanceSchedule()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceMaintenanceSchedule"/>. </summary>
        /// <param name="daily"> For schedules like: 'recur every day' or 'recur every 3 days'. </param>
        /// <param name="weekly"> For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'. </param>
        /// <param name="absoluteMonthly"> For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'. </param>
        /// <param name="relativeMonthly"> For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceMaintenanceSchedule(DailySchedule daily, ContainerServiceMaintenanceWeeklySchedule weekly, ContainerServiceMaintenanceAbsoluteMonthlySchedule absoluteMonthly, ContainerServiceMaintenanceRelativeMonthlySchedule relativeMonthly, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Daily = daily;
            Weekly = weekly;
            AbsoluteMonthly = absoluteMonthly;
            RelativeMonthly = relativeMonthly;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> For schedules like: 'recur every day' or 'recur every 3 days'. </summary>
        internal DailySchedule Daily { get; set; }
        /// <summary> Specifies the number of days between each set of occurrences. </summary>
        [WirePath("daily.intervalDays")]
        public int? DailyIntervalDays
        {
            get => Daily is null ? default(int?) : Daily.IntervalDays;
            set
            {
                Daily = value.HasValue ? new DailySchedule(value.Value) : null;
            }
        }

        /// <summary> For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'. </summary>
        [WirePath("weekly")]
        public ContainerServiceMaintenanceWeeklySchedule Weekly { get; set; }
        /// <summary> For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'. </summary>
        [WirePath("absoluteMonthly")]
        public ContainerServiceMaintenanceAbsoluteMonthlySchedule AbsoluteMonthly { get; set; }
        /// <summary> For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'. </summary>
        [WirePath("relativeMonthly")]
        public ContainerServiceMaintenanceRelativeMonthlySchedule RelativeMonthly { get; set; }
    }
}
