// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'. </summary>
    public partial class ContainerServiceMaintenanceRelativeMonthlySchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceMaintenanceRelativeMonthlySchedule"/>. </summary>
        /// <param name="intervalMonths"> Specifies the number of months between each set of occurrences. </param>
        /// <param name="weekIndex"> Specifies on which week of the month the dayOfWeek applies. </param>
        /// <param name="dayOfWeek"> Specifies on which day of the week the maintenance occurs. </param>
        public ContainerServiceMaintenanceRelativeMonthlySchedule(int intervalMonths, ContainerServiceMaintenanceRelativeMonthlyScheduleWeekIndex weekIndex, ContainerServiceWeekDay dayOfWeek)
        {
            IntervalMonths = intervalMonths;
            WeekIndex = weekIndex;
            DayOfWeek = dayOfWeek;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceMaintenanceRelativeMonthlySchedule"/>. </summary>
        /// <param name="intervalMonths"> Specifies the number of months between each set of occurrences. </param>
        /// <param name="weekIndex"> Specifies on which week of the month the dayOfWeek applies. </param>
        /// <param name="dayOfWeek"> Specifies on which day of the week the maintenance occurs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceMaintenanceRelativeMonthlySchedule(int intervalMonths, ContainerServiceMaintenanceRelativeMonthlyScheduleWeekIndex weekIndex, ContainerServiceWeekDay dayOfWeek, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IntervalMonths = intervalMonths;
            WeekIndex = weekIndex;
            DayOfWeek = dayOfWeek;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceMaintenanceRelativeMonthlySchedule"/> for deserialization. </summary>
        internal ContainerServiceMaintenanceRelativeMonthlySchedule()
        {
        }

        /// <summary> Specifies the number of months between each set of occurrences. </summary>
        [WirePath("intervalMonths")]
        public int IntervalMonths { get; set; }
        /// <summary> Specifies on which week of the month the dayOfWeek applies. </summary>
        [WirePath("weekIndex")]
        public ContainerServiceMaintenanceRelativeMonthlyScheduleWeekIndex WeekIndex { get; set; }
        /// <summary> Specifies on which day of the week the maintenance occurs. </summary>
        [WirePath("dayOfWeek")]
        public ContainerServiceWeekDay DayOfWeek { get; set; }
    }
}
