// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The default is 'standard'. See [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load balancer SKUs. </summary>
    public readonly partial struct ContainerServiceLoadBalancerSku : IEquatable<ContainerServiceLoadBalancerSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceLoadBalancerSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerServiceLoadBalancerSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "standard";
        private const string BasicValue = "basic";

        /// <summary> Use a a standard Load Balancer. This is the recommended Load Balancer SKU. For more information about on working with the load balancer in the managed cluster, see the [standard Load Balancer](https://docs.microsoft.com/azure/aks/load-balancer-standard) article. </summary>
        public static ContainerServiceLoadBalancerSku Standard { get; } = new ContainerServiceLoadBalancerSku(StandardValue);
        /// <summary> Use a basic Load Balancer with limited functionality. </summary>
        public static ContainerServiceLoadBalancerSku Basic { get; } = new ContainerServiceLoadBalancerSku(BasicValue);
        /// <summary> Determines if two <see cref="ContainerServiceLoadBalancerSku"/> values are the same. </summary>
        public static bool operator ==(ContainerServiceLoadBalancerSku left, ContainerServiceLoadBalancerSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerServiceLoadBalancerSku"/> values are not the same. </summary>
        public static bool operator !=(ContainerServiceLoadBalancerSku left, ContainerServiceLoadBalancerSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerServiceLoadBalancerSku"/>. </summary>
        public static implicit operator ContainerServiceLoadBalancerSku(string value) => new ContainerServiceLoadBalancerSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerServiceLoadBalancerSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerServiceLoadBalancerSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
