// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> For example, between '2022-12-23' and '2023-01-05'. </summary>
    public partial class ContainerServiceDateSpan
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerServiceDateSpan"/>. </summary>
        /// <param name="start"> The start date of the date span. </param>
        /// <param name="end"> The end date of the date span. </param>
        public ContainerServiceDateSpan(DateTimeOffset start, DateTimeOffset end)
        {
            Start = start;
            End = end;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceDateSpan"/>. </summary>
        /// <param name="start"> The start date of the date span. </param>
        /// <param name="end"> The end date of the date span. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerServiceDateSpan(DateTimeOffset start, DateTimeOffset end, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Start = start;
            End = end;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerServiceDateSpan"/> for deserialization. </summary>
        internal ContainerServiceDateSpan()
        {
        }

        /// <summary> The start date of the date span. </summary>
        [WirePath("start")]
        public DateTimeOffset Start { get; set; }
        /// <summary> The end date of the date span. </summary>
        [WirePath("end")]
        public DateTimeOffset End { get; set; }
    }
}
