// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> Version information about a product/service that is compatible with a service mesh revision. </summary>
    public partial class CompatibleVersions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CompatibleVersions"/>. </summary>
        public CompatibleVersions()
        {
            Versions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="CompatibleVersions"/>. </summary>
        /// <param name="name"> The product/service name. </param>
        /// <param name="versions"> Product/service versions compatible with a service mesh add-on revision. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CompatibleVersions(string name, IList<string> versions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Versions = versions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The product/service name. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Product/service versions compatible with a service mesh add-on revision. </summary>
        [WirePath("versions")]
        public IList<string> Versions { get; }
    }
}
