// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The type of Agent Pool. </summary>
    public readonly partial struct AgentPoolType : IEquatable<AgentPoolType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AgentPoolType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AgentPoolType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VirtualMachineScaleSetsValue = "VirtualMachineScaleSets";
        private const string AvailabilitySetValue = "AvailabilitySet";

        /// <summary> Create an Agent Pool backed by a Virtual Machine Scale Set. </summary>
        public static AgentPoolType VirtualMachineScaleSets { get; } = new AgentPoolType(VirtualMachineScaleSetsValue);
        /// <summary> Use of this is strongly discouraged. </summary>
        public static AgentPoolType AvailabilitySet { get; } = new AgentPoolType(AvailabilitySetValue);
        /// <summary> Determines if two <see cref="AgentPoolType"/> values are the same. </summary>
        public static bool operator ==(AgentPoolType left, AgentPoolType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AgentPoolType"/> values are not the same. </summary>
        public static bool operator !=(AgentPoolType left, AgentPoolType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AgentPoolType"/>. </summary>
        public static implicit operator AgentPoolType(string value) => new AgentPoolType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AgentPoolType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AgentPoolType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
