// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> The network protocol of the port. </summary>
    public readonly partial struct AgentPoolNetworkPortProtocol : IEquatable<AgentPoolNetworkPortProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AgentPoolNetworkPortProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AgentPoolNetworkPortProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "TCP";
        private const string UdpValue = "UDP";

        /// <summary> TCP protocol. </summary>
        public static AgentPoolNetworkPortProtocol Tcp { get; } = new AgentPoolNetworkPortProtocol(TcpValue);
        /// <summary> UDP protocol. </summary>
        public static AgentPoolNetworkPortProtocol Udp { get; } = new AgentPoolNetworkPortProtocol(UdpValue);
        /// <summary> Determines if two <see cref="AgentPoolNetworkPortProtocol"/> values are the same. </summary>
        public static bool operator ==(AgentPoolNetworkPortProtocol left, AgentPoolNetworkPortProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AgentPoolNetworkPortProtocol"/> values are not the same. </summary>
        public static bool operator !=(AgentPoolNetworkPortProtocol left, AgentPoolNetworkPortProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AgentPoolNetworkPortProtocol"/>. </summary>
        public static implicit operator AgentPoolNetworkPortProtocol(string value) => new AgentPoolNetworkPortProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AgentPoolNetworkPortProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AgentPoolNetworkPortProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
