// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ContainerService.Models
{
    /// <summary> A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools. </summary>
    public readonly partial struct AgentPoolMode : IEquatable<AgentPoolMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AgentPoolMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AgentPoolMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemValue = "System";
        private const string UserValue = "User";

        /// <summary> System agent pools are primarily for hosting critical system pods such as CoreDNS and metrics-server. System agent pools osType must be Linux. System agent pools VM SKU must have at least 2vCPUs and 4GB of memory. </summary>
        public static AgentPoolMode System { get; } = new AgentPoolMode(SystemValue);
        /// <summary> User agent pools are primarily for hosting your application pods. </summary>
        public static AgentPoolMode User { get; } = new AgentPoolMode(UserValue);
        /// <summary> Determines if two <see cref="AgentPoolMode"/> values are the same. </summary>
        public static bool operator ==(AgentPoolMode left, AgentPoolMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AgentPoolMode"/> values are not the same. </summary>
        public static bool operator !=(AgentPoolMode left, AgentPoolMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AgentPoolMode"/>. </summary>
        public static implicit operator AgentPoolMode(string value) => new AgentPoolMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AgentPoolMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AgentPoolMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
