// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerService
{
    internal class ContainerServiceTrustedAccessRoleBindingOperationSource : IOperationSource<ContainerServiceTrustedAccessRoleBindingResource>
    {
        private readonly ArmClient _client;

        internal ContainerServiceTrustedAccessRoleBindingOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerServiceTrustedAccessRoleBindingResource IOperationSource<ContainerServiceTrustedAccessRoleBindingResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerServiceTrustedAccessRoleBindingData.DeserializeContainerServiceTrustedAccessRoleBindingData(document.RootElement);
            return new ContainerServiceTrustedAccessRoleBindingResource(_client, data);
        }

        async ValueTask<ContainerServiceTrustedAccessRoleBindingResource> IOperationSource<ContainerServiceTrustedAccessRoleBindingResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerServiceTrustedAccessRoleBindingData.DeserializeContainerServiceTrustedAccessRoleBindingData(document.RootElement);
            return new ContainerServiceTrustedAccessRoleBindingResource(_client, data);
        }
    }
}
