// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ContainerService
{
    internal class ContainerServiceAgentPoolOperationSource : IOperationSource<ContainerServiceAgentPoolResource>
    {
        private readonly ArmClient _client;

        internal ContainerServiceAgentPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        ContainerServiceAgentPoolResource IOperationSource<ContainerServiceAgentPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ContainerServiceAgentPoolData.DeserializeContainerServiceAgentPoolData(document.RootElement);
            return new ContainerServiceAgentPoolResource(_client, data);
        }

        async ValueTask<ContainerServiceAgentPoolResource> IOperationSource<ContainerServiceAgentPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ContainerServiceAgentPoolData.DeserializeContainerServiceAgentPoolData(document.RootElement);
            return new ContainerServiceAgentPoolResource(_client, data);
        }
    }
}
