// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.ContainerService.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ContainerService
{
    public partial class ContainerServiceManagedClusterData : IUtf8JsonSerializable, IJsonModel<ContainerServiceManagedClusterData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerServiceManagedClusterData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerServiceManagedClusterData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceManagedClusterData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerServiceManagedClusterData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(Sku, options);
            }
            if (Optional.IsDefined(ExtendedLocation))
            {
                writer.WritePropertyName("extendedLocation"u8);
                JsonSerializer.Serialize(writer, ExtendedLocation);
            }
            if (Optional.IsDefined(ClusterIdentity))
            {
                writer.WritePropertyName("identity"u8);
                writer.WriteObjectValue(ClusterIdentity, options);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (options.Format != "W" && Optional.IsDefined(PowerState))
            {
                writer.WritePropertyName("powerState"u8);
                writer.WriteObjectValue(PowerState, options);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxAgentPools))
            {
                writer.WritePropertyName("maxAgentPools"u8);
                writer.WriteNumberValue(MaxAgentPools.Value);
            }
            if (Optional.IsDefined(KubernetesVersion))
            {
                writer.WritePropertyName("kubernetesVersion"u8);
                writer.WriteStringValue(KubernetesVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentKubernetesVersion))
            {
                writer.WritePropertyName("currentKubernetesVersion"u8);
                writer.WriteStringValue(CurrentKubernetesVersion);
            }
            if (Optional.IsDefined(DnsPrefix))
            {
                writer.WritePropertyName("dnsPrefix"u8);
                writer.WriteStringValue(DnsPrefix);
            }
            if (Optional.IsDefined(FqdnSubdomain))
            {
                writer.WritePropertyName("fqdnSubdomain"u8);
                writer.WriteStringValue(FqdnSubdomain);
            }
            if (options.Format != "W" && Optional.IsDefined(Fqdn))
            {
                writer.WritePropertyName("fqdn"u8);
                writer.WriteStringValue(Fqdn);
            }
            if (options.Format != "W" && Optional.IsDefined(PrivateFqdn))
            {
                writer.WritePropertyName("privateFQDN"u8);
                writer.WriteStringValue(PrivateFqdn);
            }
            if (options.Format != "W" && Optional.IsDefined(AzurePortalFqdn))
            {
                writer.WritePropertyName("azurePortalFQDN"u8);
                writer.WriteStringValue(AzurePortalFqdn);
            }
            if (Optional.IsCollectionDefined(AgentPoolProfiles))
            {
                writer.WritePropertyName("agentPoolProfiles"u8);
                writer.WriteStartArray();
                foreach (var item in AgentPoolProfiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(LinuxProfile))
            {
                writer.WritePropertyName("linuxProfile"u8);
                writer.WriteObjectValue(LinuxProfile, options);
            }
            if (Optional.IsDefined(WindowsProfile))
            {
                writer.WritePropertyName("windowsProfile"u8);
                writer.WriteObjectValue(WindowsProfile, options);
            }
            if (Optional.IsDefined(ServicePrincipalProfile))
            {
                writer.WritePropertyName("servicePrincipalProfile"u8);
                writer.WriteObjectValue(ServicePrincipalProfile, options);
            }
            if (Optional.IsCollectionDefined(AddonProfiles))
            {
                writer.WritePropertyName("addonProfiles"u8);
                writer.WriteStartObject();
                foreach (var item in AddonProfiles)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteObjectValue(item.Value, options);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsDefined(PodIdentityProfile))
            {
                writer.WritePropertyName("podIdentityProfile"u8);
                writer.WriteObjectValue(PodIdentityProfile, options);
            }
            if (Optional.IsDefined(OidcIssuerProfile))
            {
                writer.WritePropertyName("oidcIssuerProfile"u8);
                writer.WriteObjectValue(OidcIssuerProfile, options);
            }
            if (Optional.IsDefined(NodeResourceGroup))
            {
                writer.WritePropertyName("nodeResourceGroup"u8);
                writer.WriteStringValue(NodeResourceGroup);
            }
            if (Optional.IsDefined(EnableRbac))
            {
                writer.WritePropertyName("enableRBAC"u8);
                writer.WriteBooleanValue(EnableRbac.Value);
            }
            if (Optional.IsDefined(SupportPlan))
            {
                writer.WritePropertyName("supportPlan"u8);
                writer.WriteStringValue(SupportPlan.Value.ToString());
            }
            if (Optional.IsDefined(EnablePodSecurityPolicy))
            {
                writer.WritePropertyName("enablePodSecurityPolicy"u8);
                writer.WriteBooleanValue(EnablePodSecurityPolicy.Value);
            }
            if (Optional.IsDefined(NetworkProfile))
            {
                writer.WritePropertyName("networkProfile"u8);
                writer.WriteObjectValue(NetworkProfile, options);
            }
            if (Optional.IsDefined(AadProfile))
            {
                writer.WritePropertyName("aadProfile"u8);
                writer.WriteObjectValue(AadProfile, options);
            }
            if (Optional.IsDefined(AutoUpgradeProfile))
            {
                writer.WritePropertyName("autoUpgradeProfile"u8);
                writer.WriteObjectValue(AutoUpgradeProfile, options);
            }
            if (Optional.IsDefined(UpgradeSettings))
            {
                writer.WritePropertyName("upgradeSettings"u8);
                writer.WriteObjectValue(UpgradeSettings, options);
            }
            if (Optional.IsDefined(AutoScalerProfile))
            {
                writer.WritePropertyName("autoScalerProfile"u8);
                writer.WriteObjectValue(AutoScalerProfile, options);
            }
            if (Optional.IsDefined(ApiServerAccessProfile))
            {
                writer.WritePropertyName("apiServerAccessProfile"u8);
                writer.WriteObjectValue(ApiServerAccessProfile, options);
            }
            if (Optional.IsDefined(DiskEncryptionSetId))
            {
                writer.WritePropertyName("diskEncryptionSetID"u8);
                writer.WriteStringValue(DiskEncryptionSetId);
            }
            if (Optional.IsCollectionDefined(IdentityProfile))
            {
                writer.WritePropertyName("identityProfile"u8);
                writer.WriteStartObject();
                foreach (var item in IdentityProfile)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteObjectValue(item.Value, options);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(PrivateLinkResources))
            {
                writer.WritePropertyName("privateLinkResources"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateLinkResources)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DisableLocalAccounts))
            {
                writer.WritePropertyName("disableLocalAccounts"u8);
                writer.WriteBooleanValue(DisableLocalAccounts.Value);
            }
            if (Optional.IsDefined(HttpProxyConfig))
            {
                writer.WritePropertyName("httpProxyConfig"u8);
                writer.WriteObjectValue(HttpProxyConfig, options);
            }
            if (Optional.IsDefined(SecurityProfile))
            {
                writer.WritePropertyName("securityProfile"u8);
                writer.WriteObjectValue(SecurityProfile, options);
            }
            if (Optional.IsDefined(StorageProfile))
            {
                writer.WritePropertyName("storageProfile"u8);
                writer.WriteObjectValue(StorageProfile, options);
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                writer.WritePropertyName("publicNetworkAccess"u8);
                writer.WriteStringValue(PublicNetworkAccess.Value.ToString());
            }
            if (Optional.IsDefined(WorkloadAutoScalerProfile))
            {
                writer.WritePropertyName("workloadAutoScalerProfile"u8);
                writer.WriteObjectValue(WorkloadAutoScalerProfile, options);
            }
            if (Optional.IsDefined(AzureMonitorProfile))
            {
                writer.WritePropertyName("azureMonitorProfile"u8);
                writer.WriteObjectValue(AzureMonitorProfile, options);
            }
            if (Optional.IsDefined(ServiceMeshProfile))
            {
                writer.WritePropertyName("serviceMeshProfile"u8);
                writer.WriteObjectValue(ServiceMeshProfile, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceId))
            {
                writer.WritePropertyName("resourceUID"u8);
                writer.WriteStringValue(ResourceId);
            }
            writer.WriteEndObject();
        }

        ContainerServiceManagedClusterData IJsonModel<ContainerServiceManagedClusterData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceManagedClusterData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerServiceManagedClusterData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerServiceManagedClusterData(document.RootElement, options);
        }

        internal static ContainerServiceManagedClusterData DeserializeContainerServiceManagedClusterData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ManagedClusterSku sku = default;
            ExtendedLocation extendedLocation = default;
            ManagedClusterIdentity identity = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string provisioningState = default;
            ContainerServicePowerState powerState = default;
            int? maxAgentPools = default;
            string kubernetesVersion = default;
            string currentKubernetesVersion = default;
            string dnsPrefix = default;
            string fqdnSubdomain = default;
            string fqdn = default;
            string privateFQDN = default;
            string azurePortalFQDN = default;
            IList<ManagedClusterAgentPoolProfile> agentPoolProfiles = default;
            ContainerServiceLinuxProfile linuxProfile = default;
            ManagedClusterWindowsProfile windowsProfile = default;
            ManagedClusterServicePrincipalProfile servicePrincipalProfile = default;
            IDictionary<string, ManagedClusterAddonProfile> addonProfiles = default;
            ManagedClusterPodIdentityProfile podIdentityProfile = default;
            ManagedClusterOidcIssuerProfile oidcIssuerProfile = default;
            string nodeResourceGroup = default;
            bool? enableRBAC = default;
            KubernetesSupportPlan? supportPlan = default;
            bool? enablePodSecurityPolicy = default;
            ContainerServiceNetworkProfile networkProfile = default;
            ManagedClusterAadProfile aadProfile = default;
            ManagedClusterAutoUpgradeProfile autoUpgradeProfile = default;
            ClusterUpgradeSettings upgradeSettings = default;
            ManagedClusterAutoScalerProfile autoScalerProfile = default;
            ManagedClusterApiServerAccessProfile apiServerAccessProfile = default;
            ResourceIdentifier diskEncryptionSetId = default;
            IDictionary<string, ContainerServiceUserAssignedIdentity> identityProfile = default;
            IList<ContainerServicePrivateLinkResourceData> privateLinkResources = default;
            bool? disableLocalAccounts = default;
            ManagedClusterHttpProxyConfig httpProxyConfig = default;
            ManagedClusterSecurityProfile securityProfile = default;
            ManagedClusterStorageProfile storageProfile = default;
            ContainerServicePublicNetworkAccess? publicNetworkAccess = default;
            ManagedClusterWorkloadAutoScalerProfile workloadAutoScalerProfile = default;
            ManagedClusterAzureMonitorProfile azureMonitorProfile = default;
            ServiceMeshProfile serviceMeshProfile = default;
            ResourceIdentifier resourceUID = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sku"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sku = ManagedClusterSku.DeserializeManagedClusterSku(property.Value, options);
                    continue;
                }
                if (property.NameEquals("extendedLocation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    extendedLocation = JsonSerializer.Deserialize<ExtendedLocation>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = ManagedClusterIdentity.DeserializeManagedClusterIdentity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("powerState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            powerState = ContainerServicePowerState.DeserializeContainerServicePowerState(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("maxAgentPools"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maxAgentPools = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("kubernetesVersion"u8))
                        {
                            kubernetesVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("currentKubernetesVersion"u8))
                        {
                            currentKubernetesVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("dnsPrefix"u8))
                        {
                            dnsPrefix = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("fqdnSubdomain"u8))
                        {
                            fqdnSubdomain = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("fqdn"u8))
                        {
                            fqdn = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("privateFQDN"u8))
                        {
                            privateFQDN = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("azurePortalFQDN"u8))
                        {
                            azurePortalFQDN = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("agentPoolProfiles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ManagedClusterAgentPoolProfile> array = new List<ManagedClusterAgentPoolProfile>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ManagedClusterAgentPoolProfile.DeserializeManagedClusterAgentPoolProfile(item, options));
                            }
                            agentPoolProfiles = array;
                            continue;
                        }
                        if (property0.NameEquals("linuxProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            linuxProfile = ContainerServiceLinuxProfile.DeserializeContainerServiceLinuxProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("windowsProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            windowsProfile = ManagedClusterWindowsProfile.DeserializeManagedClusterWindowsProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("servicePrincipalProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            servicePrincipalProfile = ManagedClusterServicePrincipalProfile.DeserializeManagedClusterServicePrincipalProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("addonProfiles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, ManagedClusterAddonProfile> dictionary = new Dictionary<string, ManagedClusterAddonProfile>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, ManagedClusterAddonProfile.DeserializeManagedClusterAddonProfile(property1.Value, options));
                            }
                            addonProfiles = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("podIdentityProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            podIdentityProfile = ManagedClusterPodIdentityProfile.DeserializeManagedClusterPodIdentityProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("oidcIssuerProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            oidcIssuerProfile = ManagedClusterOidcIssuerProfile.DeserializeManagedClusterOidcIssuerProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("nodeResourceGroup"u8))
                        {
                            nodeResourceGroup = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("enableRBAC"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableRBAC = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("supportPlan"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            supportPlan = new KubernetesSupportPlan(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("enablePodSecurityPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enablePodSecurityPolicy = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("networkProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            networkProfile = ContainerServiceNetworkProfile.DeserializeContainerServiceNetworkProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("aadProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            aadProfile = ManagedClusterAadProfile.DeserializeManagedClusterAadProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("autoUpgradeProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoUpgradeProfile = ManagedClusterAutoUpgradeProfile.DeserializeManagedClusterAutoUpgradeProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("upgradeSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            upgradeSettings = ClusterUpgradeSettings.DeserializeClusterUpgradeSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("autoScalerProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoScalerProfile = ManagedClusterAutoScalerProfile.DeserializeManagedClusterAutoScalerProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("apiServerAccessProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            apiServerAccessProfile = ManagedClusterApiServerAccessProfile.DeserializeManagedClusterApiServerAccessProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("diskEncryptionSetID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            diskEncryptionSetId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("identityProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, ContainerServiceUserAssignedIdentity> dictionary = new Dictionary<string, ContainerServiceUserAssignedIdentity>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, ContainerServiceUserAssignedIdentity.DeserializeContainerServiceUserAssignedIdentity(property1.Value, options));
                            }
                            identityProfile = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("privateLinkResources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ContainerServicePrivateLinkResourceData> array = new List<ContainerServicePrivateLinkResourceData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ContainerServicePrivateLinkResourceData.DeserializeContainerServicePrivateLinkResourceData(item, options));
                            }
                            privateLinkResources = array;
                            continue;
                        }
                        if (property0.NameEquals("disableLocalAccounts"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            disableLocalAccounts = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("httpProxyConfig"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            httpProxyConfig = ManagedClusterHttpProxyConfig.DeserializeManagedClusterHttpProxyConfig(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("securityProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            securityProfile = ManagedClusterSecurityProfile.DeserializeManagedClusterSecurityProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("storageProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            storageProfile = ManagedClusterStorageProfile.DeserializeManagedClusterStorageProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccess = new ContainerServicePublicNetworkAccess(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("workloadAutoScalerProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            workloadAutoScalerProfile = ManagedClusterWorkloadAutoScalerProfile.DeserializeManagedClusterWorkloadAutoScalerProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("azureMonitorProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            azureMonitorProfile = ManagedClusterAzureMonitorProfile.DeserializeManagedClusterAzureMonitorProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("serviceMeshProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            serviceMeshProfile = ServiceMeshProfile.DeserializeServiceMeshProfile(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("resourceUID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceUID = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerServiceManagedClusterData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                sku,
                extendedLocation,
                identity,
                provisioningState,
                powerState,
                maxAgentPools,
                kubernetesVersion,
                currentKubernetesVersion,
                dnsPrefix,
                fqdnSubdomain,
                fqdn,
                privateFQDN,
                azurePortalFQDN,
                agentPoolProfiles ?? new ChangeTrackingList<ManagedClusterAgentPoolProfile>(),
                linuxProfile,
                windowsProfile,
                servicePrincipalProfile,
                addonProfiles ?? new ChangeTrackingDictionary<string, ManagedClusterAddonProfile>(),
                podIdentityProfile,
                oidcIssuerProfile,
                nodeResourceGroup,
                enableRBAC,
                supportPlan,
                enablePodSecurityPolicy,
                networkProfile,
                aadProfile,
                autoUpgradeProfile,
                upgradeSettings,
                autoScalerProfile,
                apiServerAccessProfile,
                diskEncryptionSetId,
                identityProfile ?? new ChangeTrackingDictionary<string, ContainerServiceUserAssignedIdentity>(),
                privateLinkResources ?? new ChangeTrackingList<ContainerServicePrivateLinkResourceData>(),
                disableLocalAccounts,
                httpProxyConfig,
                securityProfile,
                storageProfile,
                publicNetworkAccess,
                workloadAutoScalerProfile,
                azureMonitorProfile,
                serviceMeshProfile,
                resourceUID,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Sku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sku: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Sku))
                {
                    builder.Append("  sku: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Sku, options, 2, false, "  sku: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExtendedLocation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  extendedLocation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExtendedLocation))
                {
                    builder.Append("  extendedLocation: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ExtendedLocation, options, 2, false, "  extendedLocation: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterIdentity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterIdentity))
                {
                    builder.Append("  identity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ClusterIdentity, options, 2, false, "  identity: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    if (ProvisioningState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProvisioningState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProvisioningState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("PowerStateCode", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    powerState: ");
                builder.AppendLine("{");
                builder.AppendLine("      powerState: {");
                builder.Append("        code: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(PowerState))
                {
                    builder.Append("    powerState: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PowerState, options, 4, false, "    powerState: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxAgentPools), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    maxAgentPools: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxAgentPools))
                {
                    builder.Append("    maxAgentPools: ");
                    builder.AppendLine($"{MaxAgentPools.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KubernetesVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    kubernetesVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KubernetesVersion))
                {
                    builder.Append("    kubernetesVersion: ");
                    if (KubernetesVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{KubernetesVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{KubernetesVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentKubernetesVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentKubernetesVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentKubernetesVersion))
                {
                    builder.Append("    currentKubernetesVersion: ");
                    if (CurrentKubernetesVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentKubernetesVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentKubernetesVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DnsPrefix), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dnsPrefix: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DnsPrefix))
                {
                    builder.Append("    dnsPrefix: ");
                    if (DnsPrefix.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DnsPrefix}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DnsPrefix}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FqdnSubdomain), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    fqdnSubdomain: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FqdnSubdomain))
                {
                    builder.Append("    fqdnSubdomain: ");
                    if (FqdnSubdomain.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{FqdnSubdomain}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{FqdnSubdomain}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Fqdn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    fqdn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Fqdn))
                {
                    builder.Append("    fqdn: ");
                    if (Fqdn.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Fqdn}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Fqdn}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrivateFqdn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    privateFQDN: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrivateFqdn))
                {
                    builder.Append("    privateFQDN: ");
                    if (PrivateFqdn.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrivateFqdn}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrivateFqdn}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AzurePortalFqdn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    azurePortalFQDN: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AzurePortalFqdn))
                {
                    builder.Append("    azurePortalFQDN: ");
                    if (AzurePortalFqdn.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AzurePortalFqdn}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AzurePortalFqdn}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AgentPoolProfiles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    agentPoolProfiles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AgentPoolProfiles))
                {
                    if (AgentPoolProfiles.Any())
                    {
                        builder.Append("    agentPoolProfiles: ");
                        builder.AppendLine("[");
                        foreach (var item in AgentPoolProfiles)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    agentPoolProfiles: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LinuxProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    linuxProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LinuxProfile))
                {
                    builder.Append("    linuxProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LinuxProfile, options, 4, false, "    linuxProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WindowsProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    windowsProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WindowsProfile))
                {
                    builder.Append("    windowsProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, WindowsProfile, options, 4, false, "    windowsProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServicePrincipalProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    servicePrincipalProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServicePrincipalProfile))
                {
                    builder.Append("    servicePrincipalProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ServicePrincipalProfile, options, 4, false, "    servicePrincipalProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AddonProfiles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    addonProfiles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AddonProfiles))
                {
                    if (AddonProfiles.Any())
                    {
                        builder.Append("    addonProfiles: ");
                        builder.AppendLine("{");
                        foreach (var item in AddonProfiles)
                        {
                            builder.Append($"        '{item.Key}': ");
                            BicepSerializationHelpers.AppendChildObject(builder, item.Value, options, 6, false, "    addonProfiles: ");
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PodIdentityProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    podIdentityProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PodIdentityProfile))
                {
                    builder.Append("    podIdentityProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PodIdentityProfile, options, 4, false, "    podIdentityProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OidcIssuerProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    oidcIssuerProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OidcIssuerProfile))
                {
                    builder.Append("    oidcIssuerProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, OidcIssuerProfile, options, 4, false, "    oidcIssuerProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeResourceGroup), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    nodeResourceGroup: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NodeResourceGroup))
                {
                    builder.Append("    nodeResourceGroup: ");
                    if (NodeResourceGroup.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NodeResourceGroup}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NodeResourceGroup}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableRbac), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableRBAC: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableRbac))
                {
                    builder.Append("    enableRBAC: ");
                    var boolValue = EnableRbac.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportPlan), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    supportPlan: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SupportPlan))
                {
                    builder.Append("    supportPlan: ");
                    builder.AppendLine($"'{SupportPlan.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnablePodSecurityPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enablePodSecurityPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnablePodSecurityPolicy))
                {
                    builder.Append("    enablePodSecurityPolicy: ");
                    var boolValue = EnablePodSecurityPolicy.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    networkProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkProfile))
                {
                    builder.Append("    networkProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, NetworkProfile, options, 4, false, "    networkProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AadProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    aadProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AadProfile))
                {
                    builder.Append("    aadProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AadProfile, options, 4, false, "    aadProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AutoUpgradeProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    autoUpgradeProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AutoUpgradeProfile))
                {
                    builder.Append("    autoUpgradeProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AutoUpgradeProfile, options, 4, false, "    autoUpgradeProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("UpgradeOverrideSettings", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    upgradeSettings: ");
                builder.AppendLine("{");
                builder.AppendLine("      upgradeSettings: {");
                builder.Append("        overrideSettings: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(UpgradeSettings))
                {
                    builder.Append("    upgradeSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UpgradeSettings, options, 4, false, "    upgradeSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AutoScalerProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    autoScalerProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AutoScalerProfile))
                {
                    builder.Append("    autoScalerProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AutoScalerProfile, options, 4, false, "    autoScalerProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApiServerAccessProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    apiServerAccessProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApiServerAccessProfile))
                {
                    builder.Append("    apiServerAccessProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ApiServerAccessProfile, options, 4, false, "    apiServerAccessProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DiskEncryptionSetId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    diskEncryptionSetID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DiskEncryptionSetId))
                {
                    builder.Append("    diskEncryptionSetID: ");
                    builder.AppendLine($"'{DiskEncryptionSetId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IdentityProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    identityProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(IdentityProfile))
                {
                    if (IdentityProfile.Any())
                    {
                        builder.Append("    identityProfile: ");
                        builder.AppendLine("{");
                        foreach (var item in IdentityProfile)
                        {
                            builder.Append($"        '{item.Key}': ");
                            BicepSerializationHelpers.AppendChildObject(builder, item.Value, options, 6, false, "    identityProfile: ");
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrivateLinkResources), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    privateLinkResources: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PrivateLinkResources))
                {
                    if (PrivateLinkResources.Any())
                    {
                        builder.Append("    privateLinkResources: ");
                        builder.AppendLine("[");
                        foreach (var item in PrivateLinkResources)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    privateLinkResources: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisableLocalAccounts), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    disableLocalAccounts: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisableLocalAccounts))
                {
                    builder.Append("    disableLocalAccounts: ");
                    var boolValue = DisableLocalAccounts.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HttpProxyConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    httpProxyConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HttpProxyConfig))
                {
                    builder.Append("    httpProxyConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, HttpProxyConfig, options, 4, false, "    httpProxyConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecurityProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    securityProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecurityProfile))
                {
                    builder.Append("    securityProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SecurityProfile, options, 4, false, "    securityProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    storageProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StorageProfile))
                {
                    builder.Append("    storageProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, StorageProfile, options, 4, false, "    storageProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublicNetworkAccess), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publicNetworkAccess: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublicNetworkAccess))
                {
                    builder.Append("    publicNetworkAccess: ");
                    builder.AppendLine($"'{PublicNetworkAccess.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WorkloadAutoScalerProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    workloadAutoScalerProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WorkloadAutoScalerProfile))
                {
                    builder.Append("    workloadAutoScalerProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, WorkloadAutoScalerProfile, options, 4, false, "    workloadAutoScalerProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("AzureMonitorMetrics", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    azureMonitorProfile: ");
                builder.AppendLine("{");
                builder.AppendLine("      azureMonitorProfile: {");
                builder.Append("        metrics: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(AzureMonitorProfile))
                {
                    builder.Append("    azureMonitorProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AzureMonitorProfile, options, 4, false, "    azureMonitorProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServiceMeshProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    serviceMeshProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServiceMeshProfile))
                {
                    builder.Append("    serviceMeshProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ServiceMeshProfile, options, 4, false, "    serviceMeshProfile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resourceUID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResourceId))
                {
                    builder.Append("    resourceUID: ");
                    builder.AppendLine($"'{ResourceId.ToString()}'");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ContainerServiceManagedClusterData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceManagedClusterData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ContainerServiceManagedClusterData)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerServiceManagedClusterData IPersistableModel<ContainerServiceManagedClusterData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceManagedClusterData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerServiceManagedClusterData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerServiceManagedClusterData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerServiceManagedClusterData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
