// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.ContainerService.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ContainerService
{
    public partial class ContainerServiceAgentPoolData : IUtf8JsonSerializable, IJsonModel<ContainerServiceAgentPoolData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerServiceAgentPoolData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerServiceAgentPoolData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceAgentPoolData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerServiceAgentPoolData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Count))
            {
                writer.WritePropertyName("count"u8);
                writer.WriteNumberValue(Count.Value);
            }
            if (Optional.IsDefined(VmSize))
            {
                writer.WritePropertyName("vmSize"u8);
                writer.WriteStringValue(VmSize);
            }
            if (Optional.IsDefined(OSDiskSizeInGB))
            {
                writer.WritePropertyName("osDiskSizeGB"u8);
                writer.WriteNumberValue(OSDiskSizeInGB.Value);
            }
            if (Optional.IsDefined(OSDiskType))
            {
                writer.WritePropertyName("osDiskType"u8);
                writer.WriteStringValue(OSDiskType.Value.ToString());
            }
            if (Optional.IsDefined(KubeletDiskType))
            {
                writer.WritePropertyName("kubeletDiskType"u8);
                writer.WriteStringValue(KubeletDiskType.Value.ToString());
            }
            if (Optional.IsDefined(WorkloadRuntime))
            {
                writer.WritePropertyName("workloadRuntime"u8);
                writer.WriteStringValue(WorkloadRuntime.Value.ToString());
            }
            if (Optional.IsDefined(VnetSubnetId))
            {
                writer.WritePropertyName("vnetSubnetID"u8);
                writer.WriteStringValue(VnetSubnetId);
            }
            if (Optional.IsDefined(PodSubnetId))
            {
                writer.WritePropertyName("podSubnetID"u8);
                writer.WriteStringValue(PodSubnetId);
            }
            if (Optional.IsDefined(MaxPods))
            {
                writer.WritePropertyName("maxPods"u8);
                writer.WriteNumberValue(MaxPods.Value);
            }
            if (Optional.IsDefined(OSType))
            {
                writer.WritePropertyName("osType"u8);
                writer.WriteStringValue(OSType.Value.ToString());
            }
            if (Optional.IsDefined(OSSku))
            {
                writer.WritePropertyName("osSKU"u8);
                writer.WriteStringValue(OSSku.Value.ToString());
            }
            if (Optional.IsDefined(MaxCount))
            {
                writer.WritePropertyName("maxCount"u8);
                writer.WriteNumberValue(MaxCount.Value);
            }
            if (Optional.IsDefined(MinCount))
            {
                writer.WritePropertyName("minCount"u8);
                writer.WriteNumberValue(MinCount.Value);
            }
            if (Optional.IsDefined(EnableAutoScaling))
            {
                writer.WritePropertyName("enableAutoScaling"u8);
                writer.WriteBooleanValue(EnableAutoScaling.Value);
            }
            if (Optional.IsDefined(ScaleDownMode))
            {
                writer.WritePropertyName("scaleDownMode"u8);
                writer.WriteStringValue(ScaleDownMode.Value.ToString());
            }
            if (Optional.IsDefined(TypePropertiesType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(TypePropertiesType.Value.ToString());
            }
            if (Optional.IsDefined(Mode))
            {
                writer.WritePropertyName("mode"u8);
                writer.WriteStringValue(Mode.Value.ToString());
            }
            if (Optional.IsDefined(OrchestratorVersion))
            {
                writer.WritePropertyName("orchestratorVersion"u8);
                writer.WriteStringValue(OrchestratorVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentOrchestratorVersion))
            {
                writer.WritePropertyName("currentOrchestratorVersion"u8);
                writer.WriteStringValue(CurrentOrchestratorVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(NodeImageVersion))
            {
                writer.WritePropertyName("nodeImageVersion"u8);
                writer.WriteStringValue(NodeImageVersion);
            }
            if (Optional.IsDefined(UpgradeSettings))
            {
                writer.WritePropertyName("upgradeSettings"u8);
                writer.WriteObjectValue(UpgradeSettings, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (Optional.IsDefined(PowerState))
            {
                writer.WritePropertyName("powerState"u8);
                writer.WriteObjectValue(PowerState, options);
            }
            if (Optional.IsCollectionDefined(AvailabilityZones))
            {
                writer.WritePropertyName("availabilityZones"u8);
                writer.WriteStartArray();
                foreach (var item in AvailabilityZones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(EnableNodePublicIP))
            {
                writer.WritePropertyName("enableNodePublicIP"u8);
                writer.WriteBooleanValue(EnableNodePublicIP.Value);
            }
            if (Optional.IsDefined(NodePublicIPPrefixId))
            {
                writer.WritePropertyName("nodePublicIPPrefixID"u8);
                writer.WriteStringValue(NodePublicIPPrefixId);
            }
            if (Optional.IsDefined(ScaleSetPriority))
            {
                writer.WritePropertyName("scaleSetPriority"u8);
                writer.WriteStringValue(ScaleSetPriority.Value.ToString());
            }
            if (Optional.IsDefined(ScaleSetEvictionPolicy))
            {
                writer.WritePropertyName("scaleSetEvictionPolicy"u8);
                writer.WriteStringValue(ScaleSetEvictionPolicy.Value.ToString());
            }
            if (Optional.IsDefined(SpotMaxPrice))
            {
                writer.WritePropertyName("spotMaxPrice"u8);
                writer.WriteNumberValue(SpotMaxPrice.Value);
            }
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(NodeLabels))
            {
                writer.WritePropertyName("nodeLabels"u8);
                writer.WriteStartObject();
                foreach (var item in NodeLabels)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(NodeTaints))
            {
                writer.WritePropertyName("nodeTaints"u8);
                writer.WriteStartArray();
                foreach (var item in NodeTaints)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ProximityPlacementGroupId))
            {
                writer.WritePropertyName("proximityPlacementGroupID"u8);
                writer.WriteStringValue(ProximityPlacementGroupId);
            }
            if (Optional.IsDefined(KubeletConfig))
            {
                writer.WritePropertyName("kubeletConfig"u8);
                writer.WriteObjectValue(KubeletConfig, options);
            }
            if (Optional.IsDefined(LinuxOSConfig))
            {
                writer.WritePropertyName("linuxOSConfig"u8);
                writer.WriteObjectValue(LinuxOSConfig, options);
            }
            if (Optional.IsDefined(EnableEncryptionAtHost))
            {
                writer.WritePropertyName("enableEncryptionAtHost"u8);
                writer.WriteBooleanValue(EnableEncryptionAtHost.Value);
            }
            if (Optional.IsDefined(EnableUltraSsd))
            {
                writer.WritePropertyName("enableUltraSSD"u8);
                writer.WriteBooleanValue(EnableUltraSsd.Value);
            }
            if (Optional.IsDefined(EnableFips))
            {
                writer.WritePropertyName("enableFIPS"u8);
                writer.WriteBooleanValue(EnableFips.Value);
            }
            if (Optional.IsDefined(GpuInstanceProfile))
            {
                writer.WritePropertyName("gpuInstanceProfile"u8);
                writer.WriteStringValue(GpuInstanceProfile.Value.ToString());
            }
            if (Optional.IsDefined(CreationData))
            {
                writer.WritePropertyName("creationData"u8);
                writer.WriteObjectValue(CreationData, options);
            }
            if (Optional.IsDefined(CapacityReservationGroupId))
            {
                writer.WritePropertyName("capacityReservationGroupID"u8);
                writer.WriteStringValue(CapacityReservationGroupId);
            }
            if (Optional.IsDefined(HostGroupId))
            {
                writer.WritePropertyName("hostGroupID"u8);
                writer.WriteStringValue(HostGroupId);
            }
            if (Optional.IsDefined(NetworkProfile))
            {
                writer.WritePropertyName("networkProfile"u8);
                writer.WriteObjectValue(NetworkProfile, options);
            }
            writer.WriteEndObject();
        }

        ContainerServiceAgentPoolData IJsonModel<ContainerServiceAgentPoolData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceAgentPoolData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerServiceAgentPoolData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerServiceAgentPoolData(document.RootElement, options);
        }

        internal static ContainerServiceAgentPoolData DeserializeContainerServiceAgentPoolData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            int? count = default;
            string vmSize = default;
            int? osDiskSizeGB = default;
            ContainerServiceOSDiskType? osDiskType = default;
            KubeletDiskType? kubeletDiskType = default;
            WorkloadRuntime? workloadRuntime = default;
            ResourceIdentifier vnetSubnetId = default;
            ResourceIdentifier podSubnetId = default;
            int? maxPods = default;
            ContainerServiceOSType? osType = default;
            ContainerServiceOSSku? osSku = default;
            int? maxCount = default;
            int? minCount = default;
            bool? enableAutoScaling = default;
            ScaleDownMode? scaleDownMode = default;
            AgentPoolType? type0 = default;
            AgentPoolMode? mode = default;
            string orchestratorVersion = default;
            string currentOrchestratorVersion = default;
            string nodeImageVersion = default;
            AgentPoolUpgradeSettings upgradeSettings = default;
            string provisioningState = default;
            ContainerServicePowerState powerState = default;
            IList<string> availabilityZones = default;
            bool? enableNodePublicIP = default;
            ResourceIdentifier nodePublicIPPrefixId = default;
            ScaleSetPriority? scaleSetPriority = default;
            ScaleSetEvictionPolicy? scaleSetEvictionPolicy = default;
            float? spotMaxPrice = default;
            IDictionary<string, string> tags = default;
            IDictionary<string, string> nodeLabels = default;
            IList<string> nodeTaints = default;
            ResourceIdentifier proximityPlacementGroupId = default;
            KubeletConfig kubeletConfig = default;
            LinuxOSConfig linuxOSConfig = default;
            bool? enableEncryptionAtHost = default;
            bool? enableUltraSsd = default;
            bool? enableFIPS = default;
            GpuInstanceProfile? gpuInstanceProfile = default;
            ContainerServiceCreationData creationData = default;
            ResourceIdentifier capacityReservationGroupId = default;
            ResourceIdentifier hostGroupId = default;
            AgentPoolNetworkProfile networkProfile = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("count"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            count = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("vmSize"u8))
                        {
                            vmSize = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("osDiskSizeGB"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            osDiskSizeGB = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("osDiskType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            osDiskType = new ContainerServiceOSDiskType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("kubeletDiskType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            kubeletDiskType = new KubeletDiskType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("workloadRuntime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            workloadRuntime = new WorkloadRuntime(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("vnetSubnetID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            vnetSubnetId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("podSubnetID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            podSubnetId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("maxPods"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maxPods = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("osType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            osType = new ContainerServiceOSType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("osSKU"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            osSku = new ContainerServiceOSSku(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("maxCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maxCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("minCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("enableAutoScaling"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableAutoScaling = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("scaleDownMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            scaleDownMode = new ScaleDownMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("type"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            type0 = new AgentPoolType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("mode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            mode = new AgentPoolMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("orchestratorVersion"u8))
                        {
                            orchestratorVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("currentOrchestratorVersion"u8))
                        {
                            currentOrchestratorVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("nodeImageVersion"u8))
                        {
                            nodeImageVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("upgradeSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            upgradeSettings = AgentPoolUpgradeSettings.DeserializeAgentPoolUpgradeSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("powerState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            powerState = ContainerServicePowerState.DeserializeContainerServicePowerState(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("availabilityZones"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            availabilityZones = array;
                            continue;
                        }
                        if (property0.NameEquals("enableNodePublicIP"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableNodePublicIP = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("nodePublicIPPrefixID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            nodePublicIPPrefixId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("scaleSetPriority"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            scaleSetPriority = new ScaleSetPriority(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("scaleSetEvictionPolicy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            scaleSetEvictionPolicy = new ScaleSetEvictionPolicy(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("spotMaxPrice"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            spotMaxPrice = property0.Value.GetSingle();
                            continue;
                        }
                        if (property0.NameEquals("tags"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            tags = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("nodeLabels"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            nodeLabels = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("nodeTaints"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            nodeTaints = array;
                            continue;
                        }
                        if (property0.NameEquals("proximityPlacementGroupID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            proximityPlacementGroupId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("kubeletConfig"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            kubeletConfig = KubeletConfig.DeserializeKubeletConfig(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("linuxOSConfig"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            linuxOSConfig = LinuxOSConfig.DeserializeLinuxOSConfig(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("enableEncryptionAtHost"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableEncryptionAtHost = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableUltraSSD"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableUltraSsd = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableFIPS"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableFIPS = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("gpuInstanceProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            gpuInstanceProfile = new GpuInstanceProfile(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("creationData"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            creationData = ContainerServiceCreationData.DeserializeContainerServiceCreationData(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("capacityReservationGroupID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            capacityReservationGroupId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("hostGroupID"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hostGroupId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("networkProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            networkProfile = AgentPoolNetworkProfile.DeserializeAgentPoolNetworkProfile(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerServiceAgentPoolData(
                id,
                name,
                type,
                systemData,
                count,
                vmSize,
                osDiskSizeGB,
                osDiskType,
                kubeletDiskType,
                workloadRuntime,
                vnetSubnetId,
                podSubnetId,
                maxPods,
                osType,
                osSku,
                maxCount,
                minCount,
                enableAutoScaling,
                scaleDownMode,
                type0,
                mode,
                orchestratorVersion,
                currentOrchestratorVersion,
                nodeImageVersion,
                upgradeSettings,
                provisioningState,
                powerState,
                availabilityZones ?? new ChangeTrackingList<string>(),
                enableNodePublicIP,
                nodePublicIPPrefixId,
                scaleSetPriority,
                scaleSetEvictionPolicy,
                spotMaxPrice,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                nodeLabels ?? new ChangeTrackingDictionary<string, string>(),
                nodeTaints ?? new ChangeTrackingList<string>(),
                proximityPlacementGroupId,
                kubeletConfig,
                linuxOSConfig,
                enableEncryptionAtHost,
                enableUltraSsd,
                enableFIPS,
                gpuInstanceProfile,
                creationData,
                capacityReservationGroupId,
                hostGroupId,
                networkProfile,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Count), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    count: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Count))
                {
                    builder.Append("    count: ");
                    builder.AppendLine($"{Count.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VmSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    vmSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VmSize))
                {
                    builder.Append("    vmSize: ");
                    if (VmSize.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{VmSize}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{VmSize}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSDiskSizeInGB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    osDiskSizeGB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSDiskSizeInGB))
                {
                    builder.Append("    osDiskSizeGB: ");
                    builder.AppendLine($"{OSDiskSizeInGB.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSDiskType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    osDiskType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSDiskType))
                {
                    builder.Append("    osDiskType: ");
                    builder.AppendLine($"'{OSDiskType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KubeletDiskType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    kubeletDiskType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KubeletDiskType))
                {
                    builder.Append("    kubeletDiskType: ");
                    builder.AppendLine($"'{KubeletDiskType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WorkloadRuntime), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    workloadRuntime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WorkloadRuntime))
                {
                    builder.Append("    workloadRuntime: ");
                    builder.AppendLine($"'{WorkloadRuntime.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VnetSubnetId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    vnetSubnetID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VnetSubnetId))
                {
                    builder.Append("    vnetSubnetID: ");
                    builder.AppendLine($"'{VnetSubnetId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PodSubnetId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    podSubnetID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PodSubnetId))
                {
                    builder.Append("    podSubnetID: ");
                    builder.AppendLine($"'{PodSubnetId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxPods), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    maxPods: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxPods))
                {
                    builder.Append("    maxPods: ");
                    builder.AppendLine($"{MaxPods.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    osType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSType))
                {
                    builder.Append("    osType: ");
                    builder.AppendLine($"'{OSType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OSSku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    osSKU: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OSSku))
                {
                    builder.Append("    osSKU: ");
                    builder.AppendLine($"'{OSSku.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    maxCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxCount))
                {
                    builder.Append("    maxCount: ");
                    builder.AppendLine($"{MaxCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MinCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    minCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MinCount))
                {
                    builder.Append("    minCount: ");
                    builder.AppendLine($"{MinCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableAutoScaling), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableAutoScaling: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableAutoScaling))
                {
                    builder.Append("    enableAutoScaling: ");
                    var boolValue = EnableAutoScaling.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScaleDownMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    scaleDownMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScaleDownMode))
                {
                    builder.Append("    scaleDownMode: ");
                    builder.AppendLine($"'{ScaleDownMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TypePropertiesType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    type: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TypePropertiesType))
                {
                    builder.Append("    type: ");
                    builder.AppendLine($"'{TypePropertiesType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Mode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    mode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Mode))
                {
                    builder.Append("    mode: ");
                    builder.AppendLine($"'{Mode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OrchestratorVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    orchestratorVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OrchestratorVersion))
                {
                    builder.Append("    orchestratorVersion: ");
                    if (OrchestratorVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{OrchestratorVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{OrchestratorVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentOrchestratorVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentOrchestratorVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentOrchestratorVersion))
                {
                    builder.Append("    currentOrchestratorVersion: ");
                    if (CurrentOrchestratorVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CurrentOrchestratorVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CurrentOrchestratorVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeImageVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    nodeImageVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NodeImageVersion))
                {
                    builder.Append("    nodeImageVersion: ");
                    if (NodeImageVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NodeImageVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NodeImageVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UpgradeSettings), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    upgradeSettings: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UpgradeSettings))
                {
                    builder.Append("    upgradeSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, UpgradeSettings, options, 4, false, "    upgradeSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    if (ProvisioningState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProvisioningState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProvisioningState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("PowerStateCode", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    powerState: ");
                builder.AppendLine("{");
                builder.AppendLine("      powerState: {");
                builder.Append("        code: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(PowerState))
                {
                    builder.Append("    powerState: ");
                    BicepSerializationHelpers.AppendChildObject(builder, PowerState, options, 4, false, "    powerState: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AvailabilityZones), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    availabilityZones: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AvailabilityZones))
                {
                    if (AvailabilityZones.Any())
                    {
                        builder.Append("    availabilityZones: ");
                        builder.AppendLine("[");
                        foreach (var item in AvailabilityZones)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableNodePublicIP), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableNodePublicIP: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableNodePublicIP))
                {
                    builder.Append("    enableNodePublicIP: ");
                    var boolValue = EnableNodePublicIP.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodePublicIPPrefixId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    nodePublicIPPrefixID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NodePublicIPPrefixId))
                {
                    builder.Append("    nodePublicIPPrefixID: ");
                    builder.AppendLine($"'{NodePublicIPPrefixId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScaleSetPriority), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    scaleSetPriority: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScaleSetPriority))
                {
                    builder.Append("    scaleSetPriority: ");
                    builder.AppendLine($"'{ScaleSetPriority.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScaleSetEvictionPolicy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    scaleSetEvictionPolicy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScaleSetEvictionPolicy))
                {
                    builder.Append("    scaleSetEvictionPolicy: ");
                    builder.AppendLine($"'{ScaleSetEvictionPolicy.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SpotMaxPrice), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    spotMaxPrice: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SpotMaxPrice))
                {
                    builder.Append("    spotMaxPrice: ");
                    builder.AppendLine($"'{SpotMaxPrice.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("    tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"        '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeLabels), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    nodeLabels: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(NodeLabels))
                {
                    if (NodeLabels.Any())
                    {
                        builder.Append("    nodeLabels: ");
                        builder.AppendLine("{");
                        foreach (var item in NodeLabels)
                        {
                            builder.Append($"        '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeTaints), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    nodeTaints: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(NodeTaints))
                {
                    if (NodeTaints.Any())
                    {
                        builder.Append("    nodeTaints: ");
                        builder.AppendLine("[");
                        foreach (var item in NodeTaints)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProximityPlacementGroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    proximityPlacementGroupID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProximityPlacementGroupId))
                {
                    builder.Append("    proximityPlacementGroupID: ");
                    builder.AppendLine($"'{ProximityPlacementGroupId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(KubeletConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    kubeletConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(KubeletConfig))
                {
                    builder.Append("    kubeletConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, KubeletConfig, options, 4, false, "    kubeletConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LinuxOSConfig), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    linuxOSConfig: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LinuxOSConfig))
                {
                    builder.Append("    linuxOSConfig: ");
                    BicepSerializationHelpers.AppendChildObject(builder, LinuxOSConfig, options, 4, false, "    linuxOSConfig: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableEncryptionAtHost), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableEncryptionAtHost: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableEncryptionAtHost))
                {
                    builder.Append("    enableEncryptionAtHost: ");
                    var boolValue = EnableEncryptionAtHost.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableUltraSsd), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableUltraSSD: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableUltraSsd))
                {
                    builder.Append("    enableUltraSSD: ");
                    var boolValue = EnableUltraSsd.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableFips), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableFIPS: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableFips))
                {
                    builder.Append("    enableFIPS: ");
                    var boolValue = EnableFips.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GpuInstanceProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    gpuInstanceProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GpuInstanceProfile))
                {
                    builder.Append("    gpuInstanceProfile: ");
                    builder.AppendLine($"'{GpuInstanceProfile.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("CreationDataSourceResourceId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    creationData: ");
                builder.AppendLine("{");
                builder.AppendLine("      creationData: {");
                builder.Append("        sourceResourceId: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(CreationData))
                {
                    builder.Append("    creationData: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CreationData, options, 4, false, "    creationData: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CapacityReservationGroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    capacityReservationGroupID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CapacityReservationGroupId))
                {
                    builder.Append("    capacityReservationGroupID: ");
                    builder.AppendLine($"'{CapacityReservationGroupId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HostGroupId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    hostGroupID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HostGroupId))
                {
                    builder.Append("    hostGroupID: ");
                    builder.AppendLine($"'{HostGroupId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NetworkProfile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    networkProfile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NetworkProfile))
                {
                    builder.Append("    networkProfile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, NetworkProfile, options, 4, false, "    networkProfile: ");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ContainerServiceAgentPoolData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceAgentPoolData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ContainerServiceAgentPoolData)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerServiceAgentPoolData IPersistableModel<ContainerServiceAgentPoolData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerServiceAgentPoolData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerServiceAgentPoolData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerServiceAgentPoolData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerServiceAgentPoolData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
