// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ContainerService.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ContainerService
{
    /// <summary>
    /// A class representing the AgentPoolSnapshot data model.
    /// A node pool snapshot resource.
    /// </summary>
    public partial class AgentPoolSnapshotData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AgentPoolSnapshotData"/>. </summary>
        /// <param name="location"> The location. </param>
        public AgentPoolSnapshotData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="AgentPoolSnapshotData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="creationData"> CreationData to be used to specify the source agent pool resource ID to create this snapshot. </param>
        /// <param name="snapshotType"> The type of a snapshot. The default is NodePool. </param>
        /// <param name="kubernetesVersion"> The version of Kubernetes. </param>
        /// <param name="nodeImageVersion"> The version of node image. </param>
        /// <param name="osType"> The operating system type. The default is Linux. </param>
        /// <param name="osSku"> Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows. </param>
        /// <param name="vmSize"> The size of the VM. </param>
        /// <param name="enableFips"> Whether to use a FIPS-enabled OS. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AgentPoolSnapshotData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ContainerServiceCreationData creationData, SnapshotType? snapshotType, string kubernetesVersion, string nodeImageVersion, ContainerServiceOSType? osType, ContainerServiceOSSku? osSku, string vmSize, bool? enableFips, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            CreationData = creationData;
            SnapshotType = snapshotType;
            KubernetesVersion = kubernetesVersion;
            NodeImageVersion = nodeImageVersion;
            OSType = osType;
            OSSku = osSku;
            VmSize = vmSize;
            EnableFips = enableFips;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AgentPoolSnapshotData"/> for deserialization. </summary>
        internal AgentPoolSnapshotData()
        {
        }

        /// <summary> CreationData to be used to specify the source agent pool resource ID to create this snapshot. </summary>
        internal ContainerServiceCreationData CreationData { get; set; }
        /// <summary> This is the ARM ID of the source object to be used to create the target object. </summary>
        [WirePath("properties.creationData.sourceResourceId")]
        public ResourceIdentifier CreationDataSourceResourceId
        {
            get => CreationData is null ? default : CreationData.SourceResourceId;
            set
            {
                if (CreationData is null)
                    CreationData = new ContainerServiceCreationData();
                CreationData.SourceResourceId = value;
            }
        }

        /// <summary> The type of a snapshot. The default is NodePool. </summary>
        [WirePath("properties.snapshotType")]
        public SnapshotType? SnapshotType { get; set; }
        /// <summary> The version of Kubernetes. </summary>
        [WirePath("properties.kubernetesVersion")]
        public string KubernetesVersion { get; }
        /// <summary> The version of node image. </summary>
        [WirePath("properties.nodeImageVersion")]
        public string NodeImageVersion { get; }
        /// <summary> The operating system type. The default is Linux. </summary>
        [WirePath("properties.osType")]
        public ContainerServiceOSType? OSType { get; }
        /// <summary> Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows. </summary>
        [WirePath("properties.osSku")]
        public ContainerServiceOSSku? OSSku { get; }
        /// <summary> The size of the VM. </summary>
        [WirePath("properties.vmSize")]
        public string VmSize { get; }
        /// <summary> Whether to use a FIPS-enabled OS. </summary>
        [WirePath("properties.enableFIPS")]
        public bool? EnableFips { get; }
    }
}
