// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ContainerService.Samples
{
    public partial class Sample_MeshRevisionProfileResource
    {
        // Get a mesh revision profile for a mesh mode
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAMeshRevisionProfileForAMeshMode()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersGet_MeshRevisionProfile.json
            // this example is just showing the usage of "ManagedClusters_GetMeshRevisionProfile" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MeshRevisionProfileResource created on azure
            // for more information of creating MeshRevisionProfileResource, please refer to the document of MeshRevisionProfileResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            AzureLocation location = new AzureLocation("location1");
            string mode = "istio";
            ResourceIdentifier meshRevisionProfileResourceId = MeshRevisionProfileResource.CreateResourceIdentifier(subscriptionId, location, mode);
            MeshRevisionProfileResource meshRevisionProfile = client.GetMeshRevisionProfileResource(meshRevisionProfileResourceId);

            // invoke the operation
            MeshRevisionProfileResource result = await meshRevisionProfile.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MeshRevisionProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
