// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ContainerService.Samples
{
    public partial class Sample_ContainerServiceTrustedAccessRoleBindingResource
    {
        // Get a trusted access role binding
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetATrustedAccessRoleBinding()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/TrustedAccessRoleBindings_Get.json
            // this example is just showing the usage of "TrustedAccessRoleBindings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceTrustedAccessRoleBindingResource created on azure
            // for more information of creating ContainerServiceTrustedAccessRoleBindingResource, please refer to the document of ContainerServiceTrustedAccessRoleBindingResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string trustedAccessRoleBindingName = "binding1";
            ResourceIdentifier containerServiceTrustedAccessRoleBindingResourceId = ContainerServiceTrustedAccessRoleBindingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, trustedAccessRoleBindingName);
            ContainerServiceTrustedAccessRoleBindingResource containerServiceTrustedAccessRoleBinding = client.GetContainerServiceTrustedAccessRoleBindingResource(containerServiceTrustedAccessRoleBindingResourceId);

            // invoke the operation
            ContainerServiceTrustedAccessRoleBindingResource result = await containerServiceTrustedAccessRoleBinding.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceTrustedAccessRoleBindingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a trusted access role binding
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateATrustedAccessRoleBinding()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/TrustedAccessRoleBindings_CreateOrUpdate.json
            // this example is just showing the usage of "TrustedAccessRoleBindings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceTrustedAccessRoleBindingResource created on azure
            // for more information of creating ContainerServiceTrustedAccessRoleBindingResource, please refer to the document of ContainerServiceTrustedAccessRoleBindingResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string trustedAccessRoleBindingName = "binding1";
            ResourceIdentifier containerServiceTrustedAccessRoleBindingResourceId = ContainerServiceTrustedAccessRoleBindingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, trustedAccessRoleBindingName);
            ContainerServiceTrustedAccessRoleBindingResource containerServiceTrustedAccessRoleBinding = client.GetContainerServiceTrustedAccessRoleBindingResource(containerServiceTrustedAccessRoleBindingResourceId);

            // invoke the operation
            ContainerServiceTrustedAccessRoleBindingData data = new ContainerServiceTrustedAccessRoleBindingData(new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/b/providers/Microsoft.MachineLearningServices/workspaces/c"), new string[]
            {
"Microsoft.MachineLearningServices/workspaces/reader","Microsoft.MachineLearningServices/workspaces/writer"
            });
            ArmOperation<ContainerServiceTrustedAccessRoleBindingResource> lro = await containerServiceTrustedAccessRoleBinding.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceTrustedAccessRoleBindingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceTrustedAccessRoleBindingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a trusted access role binding
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteATrustedAccessRoleBinding()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/TrustedAccessRoleBindings_Delete.json
            // this example is just showing the usage of "TrustedAccessRoleBindings_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceTrustedAccessRoleBindingResource created on azure
            // for more information of creating ContainerServiceTrustedAccessRoleBindingResource, please refer to the document of ContainerServiceTrustedAccessRoleBindingResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string trustedAccessRoleBindingName = "binding1";
            ResourceIdentifier containerServiceTrustedAccessRoleBindingResourceId = ContainerServiceTrustedAccessRoleBindingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, trustedAccessRoleBindingName);
            ContainerServiceTrustedAccessRoleBindingResource containerServiceTrustedAccessRoleBinding = client.GetContainerServiceTrustedAccessRoleBindingResource(containerServiceTrustedAccessRoleBindingResourceId);

            // invoke the operation
            await containerServiceTrustedAccessRoleBinding.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
