// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerService.Models;

namespace Azure.ResourceManager.ContainerService.Samples
{
    public partial class Sample_ContainerServicePrivateEndpointConnectionResource
    {
        // Get Private Endpoint Connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetPrivateEndpointConnection()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/PrivateEndpointConnectionsGet.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServicePrivateEndpointConnectionResource created on azure
            // for more information of creating ContainerServicePrivateEndpointConnectionResource, please refer to the document of ContainerServicePrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string privateEndpointConnectionName = "privateendpointconnection1";
            ResourceIdentifier containerServicePrivateEndpointConnectionResourceId = ContainerServicePrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, privateEndpointConnectionName);
            ContainerServicePrivateEndpointConnectionResource containerServicePrivateEndpointConnection = client.GetContainerServicePrivateEndpointConnectionResource(containerServicePrivateEndpointConnectionResourceId);

            // invoke the operation
            ContainerServicePrivateEndpointConnectionResource result = await containerServicePrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServicePrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update Private Endpoint Connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatePrivateEndpointConnection()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/PrivateEndpointConnectionsUpdate.json
            // this example is just showing the usage of "PrivateEndpointConnections_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServicePrivateEndpointConnectionResource created on azure
            // for more information of creating ContainerServicePrivateEndpointConnectionResource, please refer to the document of ContainerServicePrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string privateEndpointConnectionName = "privateendpointconnection1";
            ResourceIdentifier containerServicePrivateEndpointConnectionResourceId = ContainerServicePrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, privateEndpointConnectionName);
            ContainerServicePrivateEndpointConnectionResource containerServicePrivateEndpointConnection = client.GetContainerServicePrivateEndpointConnectionResource(containerServicePrivateEndpointConnectionResourceId);

            // invoke the operation
            ContainerServicePrivateEndpointConnectionData data = new ContainerServicePrivateEndpointConnectionData()
            {
                ConnectionState = new ContainerServicePrivateLinkServiceConnectionState()
                {
                    Status = ContainerServicePrivateLinkServiceConnectionStatus.Approved,
                },
            };
            ArmOperation<ContainerServicePrivateEndpointConnectionResource> lro = await containerServicePrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, data);
            ContainerServicePrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServicePrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Private Endpoint Connection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletePrivateEndpointConnection()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/PrivateEndpointConnectionsDelete.json
            // this example is just showing the usage of "PrivateEndpointConnections_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServicePrivateEndpointConnectionResource created on azure
            // for more information of creating ContainerServicePrivateEndpointConnectionResource, please refer to the document of ContainerServicePrivateEndpointConnectionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string privateEndpointConnectionName = "privateendpointconnection1";
            ResourceIdentifier containerServicePrivateEndpointConnectionResourceId = ContainerServicePrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, privateEndpointConnectionName);
            ContainerServicePrivateEndpointConnectionResource containerServicePrivateEndpointConnection = client.GetContainerServicePrivateEndpointConnectionResource(containerServicePrivateEndpointConnectionResourceId);

            // invoke the operation
            await containerServicePrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
