// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerService.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.ContainerService.Samples
{
    public partial class Sample_ContainerServiceManagedClusterCollection
    {
        // Get Managed Clusters by Resource Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetManagedClustersByResourceGroup()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersListByResourceGroup.json
            // this example is just showing the usage of "ManagedClusters_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation and iterate over the result
            await foreach (ContainerServiceManagedClusterResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ContainerServiceManagedClusterData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Managed Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetManagedCluster()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersGet.json
            // this example is just showing the usage of "ManagedClusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterResource result = await collection.GetAsync(resourceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Managed Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetManagedCluster()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersGet.json
            // this example is just showing the usage of "ManagedClusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            bool result = await collection.ExistsAsync(resourceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Managed Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetManagedCluster()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersGet.json
            // this example is just showing the usage of "ManagedClusters_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            NullableResponse<ContainerServiceManagedClusterResource> response = await collection.GetIfExistsAsync(resourceName);
            ContainerServiceManagedClusterResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ContainerServiceManagedClusterData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create Managed Cluster using an agent pool snapshot
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterUsingAnAgentPoolSnapshot()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_Snapshot.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableFips = true,
CreationDataSourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = false,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with AKS-managed NAT gateway as outbound type
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithAKSManagedNATGatewayAsOutboundType()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_ManagedNATGateway.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = false,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.ManagedNatGateway,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    NatGatewayProfile = new ManagedClusterNatGatewayProfile()
                    {
                        ManagedOutboundIPCount = 2,
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with Azure KeyVault Secrets Provider Addon
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithAzureKeyVaultSecretsProviderAddon()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_AzureKeyvaultSecretsProvider.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
["azureKeyvaultSecretsProvider"] = new ManagedClusterAddonProfile(true)
{
Config =
{
["enableSecretRotation"] = "true",
["rotationPollInterval"] = "2m",
},
},
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with Capacity Reservation Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithCapacityReservationGroup()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_CRG.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
CapacityReservationGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/capacityReservationGroups/crg1"),
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with Dedicated Host Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithDedicatedHostGroup()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_DedicatedHostGroup.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
EnableNodePublicIP = true,
HostGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = false,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with EncryptionAtHost enabled
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithEncryptionAtHostEnabled()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_EnableEncryptionAtHost.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableEncryptionAtHost = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with FIPS enabled OS
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithFIPSEnabledOS()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_EnabledFIPS.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableFips = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = false,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with GPUMIG
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithGPUMIG()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_GPUMIG.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_ND96asr_v4",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
GpuInstanceProfile = GpuInstanceProfile.Mig3G,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                HttpProxyConfig = new ManagedClusterHttpProxyConfig()
                {
                    HttpProxy = "http://myproxy.server.com:8080",
                    HttpsProxy = "https://myproxy.server.com:8080",
                    NoProxy =
{
"localhost","127.0.0.1"
},
                    TrustedCA = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with HTTP proxy configured
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithHTTPProxyConfigured()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_HTTPProxy.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                HttpProxyConfig = new ManagedClusterHttpProxyConfig()
                {
                    HttpProxy = "http://myproxy.server.com:8080",
                    HttpsProxy = "https://myproxy.server.com:8080",
                    NoProxy =
{
"localhost","127.0.0.1"
},
                    TrustedCA = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with LongTermSupport
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithLongTermSupport()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_Premium.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = ManagedClusterSkuName.Base,
                    Tier = ManagedClusterSkuTier.Premium,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableEncryptionAtHost = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                SupportPlan = KubernetesSupportPlan.AKSLongTermSupport,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                ApiServerAccessProfile = new ManagedClusterApiServerAccessProfile()
                {
                    DisableRunCommand = true,
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with Node Public IP Prefix
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithNodePublicIPPrefix()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_NodePublicIPPrefix.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
NodePublicIPPrefixId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with OSSKU
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithOSSKU()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_OSSKU.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
OSSku = ContainerServiceOSSku.AzureLinux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                HttpProxyConfig = new ManagedClusterHttpProxyConfig()
                {
                    HttpProxy = "http://myproxy.server.com:8080",
                    HttpsProxy = "https://myproxy.server.com:8080",
                    NoProxy =
{
"localhost","127.0.0.1"
},
                    TrustedCA = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with PPG
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithPPG()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_PPG.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
ProximityPlacementGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with PodIdentity enabled
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithPodIdentityEnabled()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_PodIdentity.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                PodIdentityProfile = new ManagedClusterPodIdentityProfile()
                {
                    IsEnabled = true,
                    AllowNetworkPluginKubenet = true,
                },
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with RunCommand disabled
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithRunCommandDisabled()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_DisableRunCommand.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableEncryptionAtHost = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                ApiServerAccessProfile = new ManagedClusterApiServerAccessProfile()
                {
                    DisableRunCommand = true,
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with Security Profile configured
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithSecurityProfileConfigured()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_SecurityProfile.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                SecurityProfile = new ManagedClusterSecurityProfile()
                {
                    Defender = new ManagedClusterSecurityProfileDefender()
                    {
                        LogAnalyticsWorkspaceResourceId = new ResourceIdentifier("/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
                        IsSecurityMonitoringEnabled = true,
                    },
                    IsWorkloadIdentityEnabled = true,
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with UltraSSD enabled
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithUltraSSDEnabled()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_EnableUltraSSD.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableUltraSsd = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Cluster with user-assigned NAT gateway as outbound type
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedClusterWithUserAssignedNATGatewayAsOutboundType()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_UserAssignedNATGateway.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = false,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.UserAssignedNatGateway,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Private Cluster with Public FQDN specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedPrivateClusterWithPublicFQDNSpecified()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_PrivateClusterPublicFQDN.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableEncryptionAtHost = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                ApiServerAccessProfile = new ManagedClusterApiServerAccessProfile()
                {
                    EnablePrivateCluster = true,
                    EnablePrivateClusterPublicFqdn = true,
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Managed Private Cluster with fqdn subdomain specified
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateManagedPrivateClusterWithFqdnSubdomainSpecified()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_PrivateClusterFQDNSubdomain.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                FqdnSubdomain = "domain1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
EnableEncryptionAtHost = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                ApiServerAccessProfile = new ManagedClusterApiServerAccessProfile()
                {
                    EnablePrivateCluster = true,
                    PrivateDnsZone = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io",
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update AAD Managed Cluster with EnableAzureRBAC
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateUpdateAADManagedClusterWithEnableAzureRBAC()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_UpdateWithEnableAzureRBAC.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS1_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
AvailabilityZones =
{
"1","2","3"
},
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AadProfile = new ManagedClusterAadProfile()
                {
                    IsManagedAadEnabled = true,
                    IsAzureRbacEnabled = true,
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update Managed Cluster
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateUpdateManagedCluster()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_Update.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                ClusterIdentity = new ManagedClusterIdentity()
                {
                    ResourceIdentityType = "UserAssigned",
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1")] = new UserAssignedIdentity(),
},
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS1_v2",
OSType = ContainerServiceOSType.Linux,
ScaleDownMode = ScaleDownMode.Deallocate,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
AvailabilityZones =
{
"1","2","3"
},
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                UpgradeOverrideSettings = new UpgradeOverrideSettings()
                {
                    ForceUpgrade = false,
                    Until = DateTimeOffset.Parse("2022-11-01T13:00:00Z"),
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    BalanceSimilarNodeGroups = "true",
                    Expander = AutoScaleExpander.Priority,
                    MaxNodeProvisionTime = "15m",
                    NewPodScaleUpDelay = "1m",
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                    SkipNodesWithSystemPods = "false",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update Managed Cluster with Azure Service Mesh
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateUpdateManagedClusterWithAzureServiceMesh()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_AzureServiceMesh.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS2_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
["azureKeyvaultSecretsProvider"] = new ManagedClusterAddonProfile(true)
{
Config =
{
["enableSecretRotation"] = "true",
["rotationPollInterval"] = "2m",
},
},
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                ServiceMeshProfile = new ServiceMeshProfile(ServiceMeshMode.Istio)
                {
                    Istio = new IstioServiceMesh()
                    {
                        Components = new IstioComponents()
                        {
                            IngressGateways =
{
new IstioIngressGateway(IstioIngressGatewayMode.Internal,true)
},
                            EgressGateways =
{
new IstioEgressGateway(true)
{
NodeSelector =
{
["istio"] = "egress",
},
}
},
                        },
                        CertificateAuthorityPlugin = new IstioPluginCertificateAuthority()
                        {
                            KeyVaultId = new ResourceIdentifier("/subscriptions/854c9ddb-fe9e-4aea-8d58-99ed88282881/resourceGroups/ddama-test/providers/Microsoft.KeyVault/vaults/my-akv"),
                            CertObjectName = "ca-cert",
                            KeyObjectName = "ca-key",
                            RootCertObjectName = "root-cert",
                            CertChainObjectName = "cert-chain",
                        },
                    },
                },
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update Managed Cluster with EnableAHUB
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateUpdateManagedClusterWithEnableAHUB()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_UpdateWithAHUB.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                ClusterIdentity = new ManagedClusterIdentity()
                {
                    ResourceIdentityType = "UserAssigned",
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1")] = new UserAssignedIdentity(),
},
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS1_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
AvailabilityZones =
{
"1","2","3"
},
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                    LicenseType = WindowsVmLicenseType.WindowsServer,
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update Managed Cluster with Windows gMSA enabled
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateUpdateManagedClusterWithWindowsGMSAEnabled()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_UpdateWindowsGmsa.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                ClusterIdentity = new ManagedClusterIdentity()
                {
                    ResourceIdentityType = "UserAssigned",
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1")] = new UserAssignedIdentity(),
},
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS1_v2",
OSType = ContainerServiceOSType.Linux,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
AvailabilityZones =
{
"1","2","3"
},
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                    GmsaProfile = new WindowsGmsaProfile()
                    {
                        IsEnabled = true,
                    },
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update Managed Cluster with dual-stack networking
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateUpdateManagedClusterWithDualStackNetworking()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/ManagedClustersCreate_DualStackNetworking.json
            // this example is just showing the usage of "ManagedClusters_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this ContainerServiceManagedClusterResource
            ContainerServiceManagedClusterCollection collection = resourceGroupResource.GetContainerServiceManagedClusters();

            // invoke the operation
            string resourceName = "clustername1";
            ContainerServiceManagedClusterData data = new ContainerServiceManagedClusterData(new AzureLocation("location1"))
            {
                Sku = new ManagedClusterSku()
                {
                    Name = new ManagedClusterSkuName("Basic"),
                    Tier = ManagedClusterSkuTier.Free,
                },
                ClusterIdentity = new ManagedClusterIdentity()
                {
                    ResourceIdentityType = "UserAssigned",
                    UserAssignedIdentities =
{
[new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1")] = new UserAssignedIdentity(),
},
                },
                KubernetesVersion = "",
                DnsPrefix = "dnsprefix1",
                AgentPoolProfiles =
{
new ManagedClusterAgentPoolProfile("nodepool1")
{
Count = 3,
VmSize = "Standard_DS1_v2",
OSType = ContainerServiceOSType.Linux,
ScaleDownMode = ScaleDownMode.Deallocate,
AgentPoolType = AgentPoolType.VirtualMachineScaleSets,
Mode = AgentPoolMode.System,
AvailabilityZones =
{
"1","2","3"
},
EnableNodePublicIP = true,
}
},
                LinuxProfile = new ContainerServiceLinuxProfile("azureuser", new ContainerServiceSshConfiguration(new ContainerServiceSshPublicKey[]
            {
new ContainerServiceSshPublicKey("keydata")
            })),
                WindowsProfile = new ManagedClusterWindowsProfile("azureuser")
                {
                    AdminPassword = "replacePassword1234$",
                },
                ServicePrincipalProfile = new ManagedClusterServicePrincipalProfile("clientid")
                {
                    Secret = "secret",
                },
                AddonProfiles =
{
},
                EnableRbac = true,
                EnablePodSecurityPolicy = true,
                NetworkProfile = new ContainerServiceNetworkProfile()
                {
                    OutboundType = ContainerServiceOutboundType.LoadBalancer,
                    LoadBalancerSku = ContainerServiceLoadBalancerSku.Standard,
                    LoadBalancerProfile = new ManagedClusterLoadBalancerProfile()
                    {
                        ManagedOutboundIPs = new ManagedClusterLoadBalancerProfileManagedOutboundIPs()
                        {
                            Count = 2,
                        },
                    },
                    IPFamilies =
{
IPFamily.IPv4,IPFamily.IPv6
},
                },
                AutoScalerProfile = new ManagedClusterAutoScalerProfile()
                {
                    BalanceSimilarNodeGroups = "true",
                    Expander = AutoScaleExpander.Priority,
                    MaxNodeProvisionTime = "15m",
                    NewPodScaleUpDelay = "1m",
                    ScanIntervalInSeconds = "20s",
                    ScaleDownDelayAfterAdd = "15m",
                    SkipNodesWithSystemPods = "false",
                },
                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
                Tags =
{
["archv2"] = "",
["tier"] = "production",
},
            };
            ArmOperation<ContainerServiceManagedClusterResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            ContainerServiceManagedClusterResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceManagedClusterData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
