// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ContainerService.Models;

namespace Azure.ResourceManager.ContainerService.Samples
{
    public partial class Sample_ContainerServiceAgentPoolResource
    {
        // Abort operation on agent pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task AbortLatestOperation_AbortOperationOnAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsAbortOperation.json
            // this example is just showing the usage of "AgentPools_AbortLatestOperation" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            await containerServiceAgentPool.AbortLatestOperationAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get Agent Pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsGet.json
            // this example is just showing the usage of "AgentPools_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolResource result = await containerServiceAgentPool.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool using an agent pool snapshot
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolUsingAnAgentPoolSnapshot()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_Snapshot.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                EnableFips = true,
                CreationDataSourceResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with Capacity Reservation Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithCapacityReservationGroup()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_CRG.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                CapacityReservationGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/CapacityReservationGroups/crg1"),
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with Dedicated Host Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithDedicatedHostGroup()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_DedicatedHostGroup.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                HostGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with EncryptionAtHost enabled
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithEncryptionAtHostEnabled()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_EnableEncryptionAtHost.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                EnableEncryptionAtHost = true,
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with Ephemeral OS Disk
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithEphemeralOSDisk()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_Ephemeral.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSDiskSizeInGB = 64,
                OSDiskType = ContainerServiceOSDiskType.Ephemeral,
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with FIPS enabled OS
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithFIPSEnabledOS()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_EnableFIPS.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                EnableFips = true,
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with GPUMIG
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithGPUMIG()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_GPUMIG.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_ND96asr_v4",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                KubeletConfig = new KubeletConfig()
                {
                    CpuManagerPolicy = "static",
                    IsCpuCfsQuotaEnabled = true,
                    CpuCfsQuotaPeriod = "200ms",
                    ImageGcHighThreshold = 90,
                    ImageGcLowThreshold = 70,
                    TopologyManagerPolicy = "best-effort",
                    AllowedUnsafeSysctls =
{
"kernel.msg*","net.core.somaxconn"
},
                    FailStartWithSwapOn = false,
                },
                LinuxOSConfig = new LinuxOSConfig()
                {
                    Sysctls = new SysctlConfig()
                    {
                        NetCoreWmemDefault = 12345,
                        NetIPv4TcpTwReuse = true,
                        NetIPv4IPLocalPortRange = "20000 60000",
                        KernelThreadsMax = 99999,
                    },
                    TransparentHugePageEnabled = "always",
                    TransparentHugePageDefrag = "madvise",
                    SwapFileSizeInMB = 1500,
                },
                GpuInstanceProfile = GpuInstanceProfile.Mig2G,
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with Krustlet and the WASI runtime
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithKrustletAndTheWASIRuntime()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_WasmWasi.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSDiskSizeInGB = 64,
                WorkloadRuntime = WorkloadRuntime.WasmWasi,
                OSType = ContainerServiceOSType.Linux,
                Mode = AgentPoolMode.User,
                OrchestratorVersion = "",
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with KubeletConfig and LinuxOSConfig
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithKubeletConfigAndLinuxOSConfig()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_CustomNodeConfig.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                KubeletConfig = new KubeletConfig()
                {
                    CpuManagerPolicy = "static",
                    IsCpuCfsQuotaEnabled = true,
                    CpuCfsQuotaPeriod = "200ms",
                    ImageGcHighThreshold = 90,
                    ImageGcLowThreshold = 70,
                    TopologyManagerPolicy = "best-effort",
                    AllowedUnsafeSysctls =
{
"kernel.msg*","net.core.somaxconn"
},
                    FailStartWithSwapOn = false,
                },
                LinuxOSConfig = new LinuxOSConfig()
                {
                    Sysctls = new SysctlConfig()
                    {
                        NetCoreWmemDefault = 12345,
                        NetIPv4TcpTwReuse = true,
                        NetIPv4IPLocalPortRange = "20000 60000",
                        KernelThreadsMax = 99999,
                    },
                    TransparentHugePageEnabled = "always",
                    TransparentHugePageDefrag = "madvise",
                    SwapFileSizeInMB = 1500,
                },
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with OSSKU
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithOSSKU()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_OSSKU.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OSSku = ContainerServiceOSSku.AzureLinux,
                OrchestratorVersion = "",
                KubeletConfig = new KubeletConfig()
                {
                    CpuManagerPolicy = "static",
                    IsCpuCfsQuotaEnabled = true,
                    CpuCfsQuotaPeriod = "200ms",
                    ImageGcHighThreshold = 90,
                    ImageGcLowThreshold = 70,
                    TopologyManagerPolicy = "best-effort",
                    AllowedUnsafeSysctls =
{
"kernel.msg*","net.core.somaxconn"
},
                    FailStartWithSwapOn = false,
                },
                LinuxOSConfig = new LinuxOSConfig()
                {
                    Sysctls = new SysctlConfig()
                    {
                        NetCoreWmemDefault = 12345,
                        NetIPv4TcpTwReuse = true,
                        NetIPv4IPLocalPortRange = "20000 60000",
                        KernelThreadsMax = 99999,
                    },
                    TransparentHugePageEnabled = "always",
                    TransparentHugePageDefrag = "madvise",
                    SwapFileSizeInMB = 1500,
                },
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with PPG
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithPPG()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_PPG.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                ProximityPlacementGroupId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with UltraSSD enabled
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithUltraSSDEnabled()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_EnableUltraSSD.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS2_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                EnableUltraSsd = true,
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Agent Pool with Windows OSSKU
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAgentPoolWithWindowsOSSKU()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_WindowsOSSKU.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "wnp2";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_D4s_v3",
                OSType = ContainerServiceOSType.Windows,
                OSSku = ContainerServiceOSSku.Windows2022,
                OrchestratorVersion = "1.23.3",
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Spot Agent Pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateSpotAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_Spot.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS1_v2",
                OSType = ContainerServiceOSType.Linux,
                OrchestratorVersion = "",
                ScaleSetPriority = ScaleSetPriority.Spot,
                ScaleSetEvictionPolicy = ScaleSetEvictionPolicy.Delete,
                Tags =
{
["name1"] = "val1",
},
                NodeLabels =
{
["key1"] = "val1",
},
                NodeTaints =
{
"Key1=Value1:NoSchedule"
},
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create/Update Agent Pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateUpdateAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsCreate_Update.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS1_v2",
                OSType = ContainerServiceOSType.Linux,
                Mode = AgentPoolMode.User,
                OrchestratorVersion = "",
                ScaleSetPriority = ScaleSetPriority.Spot,
                ScaleSetEvictionPolicy = ScaleSetEvictionPolicy.Delete,
                Tags =
{
["name1"] = "val1",
},
                NodeLabels =
{
["key1"] = "val1",
},
                NodeTaints =
{
"Key1=Value1:NoSchedule"
},
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Start Agent Pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StartAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPools_Start.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                PowerStateCode = ContainerServiceStateCode.Running,
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Stop Agent Pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StopAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPools_Stop.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                PowerStateCode = ContainerServiceStateCode.Stopped,
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update Agent Pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPools_Update.json
            // this example is just showing the usage of "AgentPools_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            ContainerServiceAgentPoolData data = new ContainerServiceAgentPoolData()
            {
                Count = 3,
                VmSize = "Standard_DS1_v2",
                OSType = ContainerServiceOSType.Linux,
                MaxCount = 2,
                MinCount = 2,
                EnableAutoScaling = true,
                OrchestratorVersion = "",
                ScaleSetPriority = ScaleSetPriority.Spot,
                ScaleSetEvictionPolicy = ScaleSetEvictionPolicy.Delete,
                NodeTaints =
{
"Key1=Value1:NoSchedule"
},
            };
            ArmOperation<ContainerServiceAgentPoolResource> lro = await containerServiceAgentPool.UpdateAsync(WaitUntil.Completed, data);
            ContainerServiceAgentPoolResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerServiceAgentPoolData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Agent Pool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAgentPool()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsDelete.json
            // this example is just showing the usage of "AgentPools_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            await containerServiceAgentPool.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Upgrade Agent Pool Node Image Version
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task UpgradeNodeImageVersion_UpgradeAgentPoolNodeImageVersion()
        {
            // Generated from example definition: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/stable/2023-10-01/examples/AgentPoolsUpgradeNodeImageVersion.json
            // this example is just showing the usage of "AgentPools_UpgradeNodeImageVersion" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerServiceAgentPoolResource created on azure
            // for more information of creating ContainerServiceAgentPoolResource, please refer to the document of ContainerServiceAgentPoolResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string resourceName = "clustername1";
            string agentPoolName = "agentpool1";
            ResourceIdentifier containerServiceAgentPoolResourceId = ContainerServiceAgentPoolResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, agentPoolName);
            ContainerServiceAgentPoolResource containerServiceAgentPool = client.GetContainerServiceAgentPoolResource(containerServiceAgentPoolResourceId);

            // invoke the operation
            await containerServiceAgentPool.UpgradeNodeImageVersionAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
