// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ContainerRegistry.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ContainerRegistry
{
    /// <summary>
    /// A class representing the ScopeMap data model.
    /// An object that represents a scope map for a container registry.
    /// </summary>
    public partial class ScopeMapData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScopeMapData"/>. </summary>
        public ScopeMapData()
        {
            Actions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ScopeMapData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> The user friendly description of the scope map. </param>
        /// <param name="scopeMapType"> The type of the scope map. E.g. BuildIn scope map. </param>
        /// <param name="createdOn"> The creation date of scope map. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="actions">
        /// The list of scoped permissions for registry artifacts.
        /// E.g. repositories/repository-name/content/read,
        /// repositories/repository-name/metadata/write
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScopeMapData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, string scopeMapType, DateTimeOffset? createdOn, ContainerRegistryProvisioningState? provisioningState, IList<string> actions, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            ScopeMapType = scopeMapType;
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            Actions = actions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The user friendly description of the scope map. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The type of the scope map. E.g. BuildIn scope map. </summary>
        [WirePath("properties.type")]
        public string ScopeMapType { get; }
        /// <summary> The creation date of scope map. </summary>
        [WirePath("properties.creationDate")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Provisioning state of the resource. </summary>
        [WirePath("properties.provisioningState")]
        public ContainerRegistryProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// The list of scoped permissions for registry artifacts.
        /// E.g. repositories/repository-name/content/read,
        /// repositories/repository-name/metadata/write
        /// </summary>
        [WirePath("properties.actions")]
        public IList<string> Actions { get; }
    }
}
