// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> Unknown version of TaskStepUpdateParameters. </summary>
    internal partial class UnknownTaskStepUpdateParameters : ContainerRegistryTaskStepUpdateContent
    {
        /// <summary> Initializes a new instance of <see cref="UnknownTaskStepUpdateParameters"/>. </summary>
        /// <param name="stepType"> The type of the step. </param>
        /// <param name="contextPath"> The URL(absolute or relative) of the source context for the task step. </param>
        /// <param name="contextAccessToken"> The token (git PAT or SAS token of storage account blob) associated with the context for a step. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnknownTaskStepUpdateParameters(ContainerRegistryTaskStepType stepType, string contextPath, string contextAccessToken, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(stepType, contextPath, contextAccessToken, serializedAdditionalRawData)
        {
            StepType = stepType;
        }

        /// <summary> Initializes a new instance of <see cref="UnknownTaskStepUpdateParameters"/> for deserialization. </summary>
        internal UnknownTaskStepUpdateParameters()
        {
        }
    }
}
