// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ContainerRegistry.Models
{
    /// <summary> The properties of a response to source upload request. </summary>
    public partial class SourceUploadDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SourceUploadDefinition"/>. </summary>
        internal SourceUploadDefinition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SourceUploadDefinition"/>. </summary>
        /// <param name="uploadUri"> The URL where the client can upload the source. </param>
        /// <param name="relativePath"> The relative path to the source. This is used to submit the subsequent queue build request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SourceUploadDefinition(Uri uploadUri, string relativePath, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UploadUri = uploadUri;
            RelativePath = relativePath;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The URL where the client can upload the source. </summary>
        [WirePath("uploadUrl")]
        public Uri UploadUri { get; }
        /// <summary> The relative path to the source. This is used to submit the subsequent queue build request. </summary>
        [WirePath("relativePath")]
        public string RelativePath { get; }
    }
}
